// =====================================================================
//  $Id: TUserInterface.hh,v 1.2 2003/07/30 16:18:52 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: TUserInterface.hh,v $
//  Revision 1.2  2003/07/30 16:18:52  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TUSERINTERFACE_HH
#define __TUSERINTERFACE_HH

#include "Tglobals.h"
#include "TCommandHistory.hh"
#include "TCommandTable.hh"

class TCommand;

class TUserInterface
{

  protected:
    TCommandTable theCommandTable;
    Tofstream theHistoryFileStream;
    Tstring theCurrentWorkingDirectory;
    TCommandHistory theCommandHistory;

  public:
    TUserInterface( const Tstring& history );
    virtual ~TUserInterface();

  public:
    Tint AddCommand( TCommand* command );
    Tint RemoveCommand( Tint index );
    Tvoid ClearCommands();
    TCommand* FindCommand( const Tstring& fullname );
    TCommand* FindCommand( const Tstring& name, const Tstring& path );
    TCommand* GetCommand( Tint index );
    TCommand* GetCommand( const Tstring& fullname );
    TCommand* GetCommand( const Tstring& name, const Tstring& path );
    Tvoid ExecuteCommand( const Tstring& command, const TstringList& arguments );
    Tvoid ExecuteCommand( const Tstring& command );
    Tint GetCurrentWorkingDirectoryLevel() const;
    Tstring ModifyPath( const Tstring& path ) const;

  public:
    const TCommandTable& GetCommandTable() const;
    TCommandTable& GetCommandTable();
    const Tstring& GetCurrentWorkingDirectory() const;
    Tstring& GetCurrentWorkingDirectory();
    const TCommandHistory& GetCommandHistory() const;
    TCommandHistory& GetCommandHistory();
    Tofstream& GetHistoryFileStream();
    Tvoid SetCommandTable( const TCommandTable& table );
    Tvoid SetCurrentWorkingDirectory( const Tstring& directory );
    Tvoid SetCommandHistory( const TCommandHistory& history );

  public:
    virtual Tbool AcceptCommand() = 0;
    virtual const Tstring& GetInputCommand() = 0;

  public:
    virtual Tvoid NotFoundCommand( const Tstring& commandname ) const;
    virtual Tvoid ClearScreen() const;
    virtual Tint GetNumberOfColumns() const;
    virtual Tint GetNumberOfLines() const;

};

inline const TCommandTable& TUserInterface::GetCommandTable() const
{
  return( theCommandTable );
}

inline TCommandTable& TUserInterface::GetCommandTable()
{
  return( theCommandTable );
}

inline const Tstring& TUserInterface::GetCurrentWorkingDirectory() const
{
  return( theCurrentWorkingDirectory );
}

inline Tstring& TUserInterface::GetCurrentWorkingDirectory()
{
  return( theCurrentWorkingDirectory );
}

inline const TCommandHistory& TUserInterface::GetCommandHistory() const
{
  return( theCommandHistory );
}

inline TCommandHistory& TUserInterface::GetCommandHistory()
{
  return( theCommandHistory );
}

inline Tofstream& TUserInterface::GetHistoryFileStream()
{
  return( theHistoryFileStream );
}

inline Tvoid TUserInterface::SetCommandTable( const TCommandTable& table )
{
  theCommandTable = table;
  return;
}

inline Tvoid TUserInterface::SetCommandHistory( const TCommandHistory& history )
{
  theCommandHistory = history;
  return;
}

#endif
