// =====================================================================
//  $Id: Rs00RunAction.cc,v 1.3 2003/10/06 16:28:15 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: Rs00RunAction.cc,v $
//  Revision 1.3  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:14:23  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRun.hh"
#include "TRunManager.hh"
#include "TEventManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TOutputObjectFile.hh"
#include "TReadoutBook.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TCrate.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs00RunAction.hh"

Rs00RunAction::Rs00RunAction()
  : theOutputFile( 0 )
{;}

Rs00RunAction::~Rs00RunAction()
{;}

Tvoid Rs00RunAction::BeginOfRunAction( TRun& aRun )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring drecdir = envtable.GetEnvironmentValue( "RS00_RECORD_DIR" );

  Tstring drecpath = drecdir + "run" + aRun.GetStringRunID() + ".drec";
  theCrate -> Initialize();
  theOutputFile = new TOutputObjectFile( drecpath );
  return;
}

Tvoid Rs00RunAction::EndOfRunAction( TRun& aRun )
{
  delete theOutputFile;
  theOutputFile = 0;
  return;
}
