// =====================================================================
//  $Id: TExitCommand.cc,v 1.3 2003/10/06 17:02:37 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TExitCommand.cc,v $
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TExitCommand.hh"
#include "TUserInterface.hh"
#include "TRunManager.hh"

static const Tstring _name = "exit";
static const Tstring _desc = "terminate this session by force.";

TExitCommand::TExitCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TExitCommand::~TExitCommand()
{;}

Tvoid TExitCommand::Execute( const TstringList& arguments )
{
  Tstatus_t status = theRunManager -> GetStatus();
  switch ( status ) {
    case tStatusStandby:
      theRunManager -> ShutdownRun();
      break;
    case tStatusReady:
      theRunManager -> SuspendRun();
      theRunManager -> WaitReturnFromEventLoop();
      theRunManager -> StopRun();
      theRunManager -> ShutdownRun();
      break;
    case tStatusBusy:
      theRunManager -> SuspendRun();
      theRunManager -> WaitReturnFromEventLoop();
      theRunManager -> StopRun();
      theRunManager -> ShutdownRun();
      break;
    case tStatusIdle:
      theRunManager -> StopRun();
      theRunManager -> ShutdownRun();
      break;
    case tStatusWaitingReady:
      theRunManager -> WaitReturnFromEventLoop();
      theRunManager -> StopRun();
      theRunManager -> ShutdownRun();
      break;
    default:
      break;
  }
  return;
}
