// =====================================================================
//  $Id: TCrate.cc,v 1.3 2003/10/06 17:02:40 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TCrate.cc,v $
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCrate.hh"
#include "TModule.hh"

TCrate::TCrate()
  : theModuleTable()
{
  theModuleTable.Clear();
}

TCrate::~TCrate()
{
  ClearCrate();
}

Tint TCrate::InstallModule( TModule* module, const Tstring& id, const TstringList& groups )
{
  if ( theModuleTable.FindModule( id ) != 0 ) {
    Tcerr << "TCrate::InstallModule: already exist Module identified as " << id << "." << Tendl;
  } else {
    theModuleTable.AddModule( module, id, groups );
  }
  return theModuleTable.GetSize();
}

Tint TCrate::InstallModule( TModule* module, const Tstring& id, const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  return InstallModule( module, id, groups );
}

Tint TCrate::RemoveModule( Tint index )
{
  static const Tstring head = "TCrate::RemoveModule: ";
  if ( index < 0 || index >= theModuleTable.GetSize() ) {
    Tcerr << head << "invalid index " << index << "." << Tendl;
    return theModuleTable.GetSize();
  }
  Tstring id = theModuleTable[ index ].GetModuleID();
  delete ( theModuleTable[ index ].GetModule() );
  Tcout << head << id << " module was removed." << Tendl;
  theModuleTable.RemoveModule( index );

  return theModuleTable.GetSize();
}

Tint TCrate::RemoveModule( const Tstring& id )
{
  for ( Tint i = 0; i < theModuleTable.GetSize(); i ++ ) {
    if ( theModuleTable[ i ].GetModuleID() == id ) {
      RemoveModule( i );
    }
  }
  return theModuleTable.GetSize();
}

Tint TCrate::RemoveModule( const TstringList& groups )
{
  for ( Tint i = 0; i < theModuleTable.GetSize(); i ++ ) {
    if ( theModuleTable[ i ].IsSameGroup( groups ) ) {
      RemoveModule( i );
    }
  }
  return theModuleTable.GetSize();
}

Tvoid TCrate::ClearCrate()
{
  Tstring head = "TCrate::ClearCrate: ";
  for ( Tint i = 0; i < theModuleTable.GetSize(); i ++ ) {
    if ( theModuleTable[ i ].GetModule() ) {
      Tstring id = theModuleTable[ i ].GetModuleID();
      delete ( theModuleTable[ i ].GetModule() );
      Tcout << head << id << " module was removed." << Tendl;;
    }
  }
  theModuleTable.Clear();
  return;
}

TModule* TCrate::FindModule( const Tstring& id )
{
  return theModuleTable.FindModule( id );
}

TModule* TCrate::GetModule( Tint index )
{
  if ( index < 0 || index >= theModuleTable.GetSize() ) {
    Tcerr << "TCrate::GetModule: invalid index " << index << "." << Tendl;
    return 0;
  }
  return theModuleTable[ index ].GetModule();
}

TModule* TCrate::GetModule( const Tstring& id )
{
  return FindModule( id );
}

Tvoid TCrate::Clear()
{
  for ( Tint i = 0; i < theModuleTable.GetSize(); i ++ ) {
    theModuleTable[ i ].GetModule() -> Clear();
  }
  return;
}

Tvoid TCrate::Clear( const TstringList& groups )
{
  for ( Tint i = 0; i < theModuleTable.GetSize(); i ++ ) {
    if ( theModuleTable[ i ].IsSameGroup( groups ) ) {
      theModuleTable[ i ].GetModule() -> Clear();
    }
  }
  return;
}

Tvoid TCrate::Clear( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  Clear( groups );
  return;
}

Tvoid TCrate::Update()
{
  for ( Tint i = 0; i < theModuleTable.GetSize(); i ++ ) {
    theModuleTable[ i ].GetModule() -> Update();
  }
  return;
}

Tvoid TCrate::Update( const TstringList& groups )
{
  for ( Tint i = 0; i < theModuleTable.GetSize(); i ++ ) {
    if ( theModuleTable[ i ].IsSameGroup( groups ) ) {
      theModuleTable[ i ].GetModule() -> Update();
    }
  }
  return;
}

Tvoid TCrate::Update( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  Update( groups );
  return;
}

Tvoid TCrate::Initialize()
{
  for ( Tint i = 0; i < theModuleTable.GetSize(); i ++ ) {
    theModuleTable[ i ].GetModule() -> Initialize();
  }
  return;
}

Tvoid TCrate::Initialize( const TstringList& groups )
{
  for ( Tint i = 0; i < theModuleTable.GetSize(); i ++ ) {
    if ( theModuleTable[ i ].IsSameGroup( groups ) ) {
      theModuleTable[ i ].GetModule() -> Initialize();
    }
  }
  return;
}

Tvoid TCrate::Initialize( const Tstring& group )
{
  TstringList groups;
  groups.push_back( group );
  Initialize( groups );
  return;
}

Tvoid TCrate::ClearAllModules()
{
  Clear();
  return;
}

Tvoid TCrate::UpdateAllModules()
{
  Update();
  return;
}

Tvoid TCrate::InitializeAllModules()
{
  Initialize();
  return;
}

Tvoid TCrate::ClearModule( const Tstring& id )
{
  TModule* module = FindModule( id );
  if ( module ) {
    module -> Clear();
  }
  return;
}

Tvoid TCrate::UpdateModule( const Tstring& id )
{
  TModule* module = FindModule( id );
  if ( module ) {
    module -> Update();
  }
  return;
}

Tvoid TCrate::InitializeModule( const Tstring& id )
{
  TModule* module = FindModule( id );
  if ( module ) {
    module -> Initialize();
  }
  return;
}
