// =====================================================================
//  $Id: TModuleTable.cc,v 1.3 2003/10/06 17:02:40 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TModuleTable.cc,v $
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TModuleTable.hh"

TModuleTable::TModuleTable()
  : Tvector<TModuleSpecified>()
{;}

TModuleTable::~TModuleTable()
{;}

TModule* TModuleTable::FindModule( const Tstring& id ) const
{
  for ( Tsize_t i = 0; i < size(); i ++ ) {
    if ( (*this)[ i ].GetModuleID() == id ) {
      return (*this)[ i ].GetModule();
    }
  }
  return 0;
}

Tvoid TModuleTable::AddModule( TModule* module, const Tstring& id, const TstringList& groups )
{
  TModuleSpecified spec( id, groups, module );
  push_back( spec );
  return;
}

Tvoid TModuleTable::RemoveModule( Tint index )
{
  erase( begin() + index );
  return;
}

Tint TModuleTable::GetSize() const
{
  return (Tint)size();
}

Tvoid TModuleTable::Clear()
{
  clear();
  return;
}
