// =====================================================================
/*!
//
//  \file TSoftwareRunInformationModule.hh
//  \brief This file contains the TSoftwareRunInformationModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TSoftwareRunInformationModule.hh,v 1.4 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TSoftwareRunInformationModule.hh,v $
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TSOFTWARERUNINFORMATIONMODULE_HH
#define __TSOFTWARERUNINFORMATIONMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"
#include "TRunInformationTable.hh"

class TDataSegment;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TSoftwareRunInformationModule
// \brief This is the TSoftwareRunInformationModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TSoftwareRunInformationModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TSoftwareRunInformationModule
  : public TSoftwareModule
{

  private:
    TRunInformationTable theRunInformationTable;

  public:
    TSoftwareRunInformationModule();
    TSoftwareRunInformationModule( const TRunInformationTable& table );
    TSoftwareRunInformationModule( const TSoftwareRunInformationModule& right );
    ~TSoftwareRunInformationModule();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    const TSoftwareRunInformationModule& operator=( const TSoftwareRunInformationModule& right );
    Tbool operator==( const TSoftwareRunInformationModule& right ) const;
    Tbool operator!=( const TSoftwareRunInformationModule& right ) const;

  public:
    TRunInformationTable& GetRunInformationTable();
    const TRunInformationTable& GetRunInformationTable() const;
    Tvoid SetRunInformationTable( const TRunInformationTable& table );

};

inline TRunInformationTable& TSoftwareRunInformationModule::GetRunInformationTable()
{
  return theRunInformationTable;
}

inline const TRunInformationTable& TSoftwareRunInformationModule::GetRunInformationTable() const
{
  return theRunInformationTable;
}

inline Tvoid TSoftwareRunInformationModule::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
  return;
}

#endif
