// =====================================================================
/*!
//
//  \file TSoftwareTimerModule.hh
//  \brief This file contains the TSoftwareTimerModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TSoftwareTimerModule.hh,v 1.5 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TSoftwareTimerModule.hh,v $
//  Revision 1.5  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:19:12  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TSOFTWARETIMERMODULE_HH
#define __TSOFTWARETIMERMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"
#include "TSystemTimer.hh"

class TDataElement;
class TSystemTimer;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TSoftwareTimerModule
// \brief This is the TSoftwareTimerModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TSoftwareTimerModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TSoftwareTimerModule
  : public TSoftwareModule
{

  public:
    enum { 
      tRealElapsedTime,
      tRealElapsedTimeTotal,
      tSystemElapsedTime,
      tUserElapsedTime,
      tUnit,
      tNumberOfChannels
    };

  private:
    TSystemTimer theSystemTimer;
    Tdouble theRealElapsedTimeTotal;

  public:
    TSoftwareTimerModule( Tint nchannel = tNumberOfChannels, const Tstring& unit = Tmsec );
    TSoftwareTimerModule( const Tstring& unit, Tint nchannel = tNumberOfChannels );
    TSoftwareTimerModule( const TSoftwareTimerModule& right );
    ~TSoftwareTimerModule();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tvoid Start();
    Tvoid Pause();
    Tvoid Stop();
    Tvoid Lap();
    Tvoid Restart();

  public:
    const TSystemTimer& GetSystemTimer() const;
    TSystemTimer& GetSystemTimer();
    Tvoid SetSystemTimer( const TSystemTimer& timer );
    Tdouble GetRealElapsedTimeTotal() const;
    Tvoid SetRealElapsedTimeTotal( Tdouble time );

  public:
    const TSoftwareTimerModule& operator=( const TSoftwareTimerModule& right );
    Tbool operator==( const TSoftwareTimerModule& right ) const;
    Tbool operator!=( const TSoftwareTimerModule& right ) const;

};

inline const TSystemTimer& TSoftwareTimerModule::GetSystemTimer() const
{
  return theSystemTimer;
}

inline TSystemTimer& TSoftwareTimerModule::GetSystemTimer()
{
  return theSystemTimer;
}

inline Tvoid TSoftwareTimerModule::SetSystemTimer( const TSystemTimer& timer )
{
  theSystemTimer = timer;
  return;
}

inline Tvoid TSoftwareTimerModule::Start()
{
  theSystemTimer.Start();
  return;
}

inline Tvoid TSoftwareTimerModule::Pause()
{
  theSystemTimer.Pause();
  return;
}

inline Tvoid TSoftwareTimerModule::Stop()
{
  theSystemTimer.Stop();
  theRealElapsedTimeTotal += theSystemTimer.GetRealElapsedTime();
  return;
}

inline Tvoid TSoftwareTimerModule::Lap()
{
  theSystemTimer.Lap();
  return;
}

inline Tvoid TSoftwareTimerModule::Restart()
{
  theSystemTimer.Restart();
  return;
}

inline Tdouble TSoftwareTimerModule::GetRealElapsedTimeTotal() const
{
  return theRealElapsedTimeTotal;
}

inline Tvoid TSoftwareTimerModule::SetRealElapsedTimeTotal( Tdouble time )
{
  theRealElapsedTimeTotal = time;
  return;
}

#endif
