// =====================================================================
//  $Id: TVmeDaughterBoardMemoryModule.cc,v 1.3 2003/10/06 17:02:40 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TVmeDaughterBoardMemoryModule.cc,v $
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:12  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TVmeDaughterBoardMemoryModule.hh"
#include "TVmeMpx201aModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TVmeDaughterBoardMemoryModule::TVmeDaughterBoardMemoryModule( Toff_t offset, Tint mapsize, Tint nblock, Tint nch )
  : TVmeModule( nch, offset, mapsize, tA32D32 ),
    theNumberOfSampling( nblock * TVmeMpx201aModule::tBlock )
{;}

TVmeDaughterBoardMemoryModule::TVmeDaughterBoardMemoryModule( const TVmeMpx201aModule* mpx201a, Tint nch )
  : TVmeModule( nch, mpx201a->GetOffsetAddressForDaughterBoard(), mpx201a->GetMappingSizeOfDaughterBoard(), tA32D32 ),
    theNumberOfSampling( mpx201a->GetNumberOfBlock() * TVmeMpx201aModule::tBlock )
{;}

TVmeDaughterBoardMemoryModule::TVmeDaughterBoardMemoryModule( const TVmeDaughterBoardMemoryModule& right )
  : TVmeModule( right ),
    theNumberOfSampling( right.theNumberOfSampling )
{;}

TVmeDaughterBoardMemoryModule::~TVmeDaughterBoardMemoryModule()
{;}

const TVmeDaughterBoardMemoryModule& TVmeDaughterBoardMemoryModule::operator=( const TVmeDaughterBoardMemoryModule& right )
{
  *( (TVmeModule*)this ) = *( (TVmeModule*)(&right) );
  theNumberOfSampling = right.theNumberOfSampling;
  return *this;
}

Tbool TVmeDaughterBoardMemoryModule::operator==( const TVmeDaughterBoardMemoryModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TVmeModule*)this ) == *( (TVmeModule*)(&right) ) );
  ret &= ( theNumberOfSampling == right.theNumberOfSampling );
  return ret;
}

Tbool TVmeDaughterBoardMemoryModule::operator!=( const TVmeDaughterBoardMemoryModule& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TVmeModule*)this ) != *( (TVmeModule*)(&right) ) );
  ret |= ( theNumberOfSampling != right.theNumberOfSampling );
  return ret;
}

Tint TVmeDaughterBoardMemoryModule::Clear()
{
  Tlong* membase = (Tlong*)theBaseAddress;
  Tint nsample = theNumberOfSampling / 2;
  //for ( Tint i = 0; i < theNumberOfSampling; i ++ ) {
  for ( Tint i = 0; i < nsample; i ++ ) {
    membase[ i ] = 0x0000;
  }
  return theStatus = tStatusSuccess;
}

Tint TVmeDaughterBoardMemoryModule::Update()
{
  return Clear();
}

Tint TVmeDaughterBoardMemoryModule::Initialize()
{
  return Clear();
}

Tvoid TVmeDaughterBoardMemoryModule::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TVmeDaughterBoardMemoryModule::FillData: invalid ID " << channel << Tendl;
    theStatus = -EFAULT;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    // direct access, processing speed improve.
    Tlong* membase = (Tlong*)theBaseAddress;

    //TUshort* databuf = new TUshort[ theNumberOfSampling ];
    Tint nsample = theNumberOfSampling / 2;
    Tshort* databuf = new Tshort[ nsample ];
    for ( Tint i = 0; i < nsample; i ++ ) {
      databuf[ i ] = modifyData( membase[ i ] );
    }
    //element.FillData( databuf, tTypeUnsignedShort, theNumberOfSampling );
    element.FillData( databuf, tTypeShort, nsample );
    delete [] databuf;
  }

  return;
}
