// =====================================================================
/*!
//
//  \file TInputObjectSocket.hh
//  \brief This file contains the TInputObjectSocket class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TInputObjectSocket.hh,v 1.4 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TInputObjectSocket.hh,v $
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TINPUTOBJECTSOCKET_HH
#define __TINPUTOBJECTSOCKET_HH

#include "Tglobals.h"
#include "TObjectSocket.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TInputObjectSocket
// \brief This is the TInputObjectSocket class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TInputObjectSocket class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TInputObjectSocket
  : public TObjectSocket, public TInputObjectStream
{

  private:
    enum { tDefaultBackLog = 5 };

  private:
    Tint theClientDescriptor;

  public:
    TInputObjectSocket( Tint port = tDefaultPortNumber );
    TInputObjectSocket( TObjectFilter* filter, Tint port = tDefaultPortNumber );
    ~TInputObjectSocket();

  public:
    Tint Read( TStreamableObject& object );

  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tint& recsize, Tobject_t& type, Tstring& id, Tsize_t& entries );
    Tvoid initialize();

  public:
    Tint GetClientDescriptor() const;
    // GetClientHostName()
    // GetClientPort()
    Tint OpenClient();
    Tint CloseClient();

};


inline Tint TInputObjectSocket::GetClientDescriptor() const
{
  return theClientDescriptor;
}

#endif
