// =====================================================================
/*!
//
//  \file TInputObjectStream.hh
//  \brief This file contains the TInputObjectStream class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TInputObjectStream.hh,v 1.5 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TInputObjectStream.hh,v $
//  Revision 1.5  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/11 02:56:14  goiwai
//  ǥȥ饯 protected  public °ѹޤ.餳
//  ʤ,ؤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TINPUTOBJECTSTREAM_HH
#define __TINPUTOBJECTSTREAM_HH

#include "Tglobals.h"
#include "TObjectStream.hh"

class TStreamableObject;
class TObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TInputObjectStream
// \brief This is the TInputObjectStream class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TInputObjectStream class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TInputObjectStream
  : public TObjectStream
{

  public:
    TInputObjectStream( Tstream_t streamtype = tUnknownStream );
    TInputObjectStream( TObjectFilter* filter, Tstream_t streamtype = tUnknownStream );
    virtual ~TInputObjectStream();

  public:
    virtual Tint Read( TStreamableObject& object ) = 0;
    friend Tint operator>>( TInputObjectStream& left, TStreamableObject& object );
    friend Tint operator>>( TInputObjectStream& left, const TStreamableObject& object );

};

inline Tint operator>>( TInputObjectStream& left, TStreamableObject& object )
{
  return left.Read( object );
}

inline Tint operator>>( TInputObjectStream& left, const TStreamableObject& object )
{
  return left.Read( *(TStreamableObject*)(&object) );
}

#endif
