// =====================================================================
//  $Id: TReadoutElement.cc,v 1.4 2003/10/06 16:39:00 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TReadoutElement.cc,v $
//  Revision 1.4  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutElement.hh"
#include "TDataElement.hh"
#include "TModule.hh"

TReadoutElement::TReadoutElement( TModule* module, const Tstring& id, Tint ch )
  : TReadoutIdentification( id ), theModule( module ), theChannelNumber( ch )
{
  // ֹͥ椬ά줿,IDֹͥˤ褦Ȼߤ
  if ( theChannelNumber < 0 ) {
    Tbool isiddigit = Ttrue;
    for ( Tsize_t i = 0; i < theID.size(); i ++ ) {
      if ( !isdigit( theID[ i ] ) ) {
        isiddigit = Tfalse;
        break;
      }
    }
    if ( isiddigit ) {
      theChannelNumber = (Tint)strtol( theID.c_str(), 0, 0 );
    }
  }
}

TReadoutElement::TReadoutElement( TModule* module, Tint ch, const Tstring& id )
  : TReadoutIdentification( id ), theModule( module ), theChannelNumber( ch )
{
  if ( theID == TunknownID ) {
    theID = itostr( ch, 1 );
  }
}

TReadoutElement::TReadoutElement( const TReadoutElement& right )
  : TReadoutIdentification( right ), 
    theModule( right.theModule ),
    theChannelNumber( right.theChannelNumber )
{;}

TReadoutElement::~TReadoutElement()
{;}

TDataElement TReadoutElement::Read( Tint ch )
{
  TDataElement element( tTypeUnknown, theID );
  theModule -> FillData( element, ch );
  return element;
}

TDataElement TReadoutElement::Read()
{
  return Read( theChannelNumber );
}

const TReadoutElement& TReadoutElement::operator=( const TReadoutElement& right )
{
  *( (TReadoutIdentification*)this ) = *( (TReadoutIdentification*)(&right) );
  theModule = right.theModule;
  theChannelNumber = right.theChannelNumber;
  return *this;
}

Tbool TReadoutElement::operator==( const TReadoutElement& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TReadoutIdentification*)this ) == *( (TReadoutIdentification*)(&right) ) );
  retval &= ( *theModule == *(right.theModule) );
  retval &= ( theChannelNumber == right.theChannelNumber );
  return retval;
}

Tbool TReadoutElement::operator!=( const TReadoutElement& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( *( (TReadoutIdentification*)this ) != *( (TReadoutIdentification*)(&right) ) );
  retval |= ( *theModule != *(right.theModule) );
  retval |= ( theChannelNumber != right.theChannelNumber );
  return retval;
}
