// =====================================================================
/*!
//
//  \file TRunAction.hh
//  \brief This file contains the TRunAction class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TRunAction.hh,v 1.5 2003/11/03 08:35:14 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TRunAction.hh,v $
//  Revision 1.5  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 17:02:45  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:20:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TRUNACTION_HH
#define __TRUNACTION_HH

#include "Tglobals.h"

class TRun;
class TRunManager;
class TEventManager;
class TReadoutBook;
class TCrate;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TRunAction
// \brief This is the TRunAction class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TRunAction class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup RunCategory
*/
class TRunAction
{

  protected:
    TRunManager* theRunManager;
    TEventManager* theEventManager;
    TReadoutBook* theReadoutBook;
    TCrate* theCrate;

  public:
    TRunAction();
    virtual ~TRunAction();

  public:
    virtual Tvoid BeginOfRunAction( TRun& aRun );
    virtual Tvoid EndOfRunAction( TRun& aRun );

  public:
    TRunManager* GetRunManager() const;
    TEventManager* GetEventManager() const;
    TReadoutBook* GetReadoutBook() const;
    TCrate* GetCrate() const;
    Tvoid SetRunManager( TRunManager* manager );
    Tvoid SetEventManager( TEventManager* manager );
    Tvoid SetReadoutBook( TReadoutBook* book );
    Tvoid SetCrate( TCrate* crate );

};

inline TRunManager* TRunAction::GetRunManager() const
{
  return theRunManager;
}

inline TEventManager* TRunAction::GetEventManager() const
{
  return theEventManager;
}

inline TReadoutBook* TRunAction::GetReadoutBook() const
{
  return theReadoutBook;
}

inline TCrate* TRunAction::GetCrate() const
{
  return theCrate;
}

inline Tvoid TRunAction::SetRunManager( TRunManager* manager )
{
  theRunManager = manager;
  return;
}

inline Tvoid TRunAction::SetEventManager( TEventManager* manager )
{
  theEventManager = manager;
  return;
}

inline Tvoid TRunAction::SetReadoutBook( TReadoutBook* book )
{
  theReadoutBook = book;
  return;
}

inline Tvoid TRunAction::SetCrate( TCrate* crate )
{
  theCrate = crate;
  return;
}

#endif
