// =====================================================================
//  $Id: TSignalHandler.cc,v 1.3 2003/10/06 16:38:26 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TSignalHandler.cc,v $
//  Revision 1.3  2003/10/06 16:38:26  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSignalHandler.hh"
#include "TSignalClient.hh"

typedef Tvoid SIG_FUNC_TYP(Tint);
typedef SIG_FUNC_TYP* SIG_PF;

TSignalHandler::TSignalHandler( Tint psignalid, TSignalClient* pclient )
{
  signal_id = psignalid;
  if ( psignalid < MAX_SIGNAL_ENTRY && psignalid >= 0 )
    handler_list[ psignalid ] = this;
  client = pclient;
}

Tvoid TSignalHandler::Enable()
{
  signal( signal_id, ( SIG_PF ) TSignalHandler::signal_handler );
  return;
}

Tvoid TSignalHandler::Disable()
{
  signal( signal_id, SIG_DFL );
  return;
}

Tvoid TSignalHandler::signal_handler( Tint sig, Tint code, struct sigcontext* scp, Tchar* addr )
{
  if ( handler_list[ sig ] ) {
    handler_list[ sig ] -> signal_ucr( sig );
  }
  signal( sig, ( SIG_PF )signal_handler );
  return;
}

TSignalHandler* TSignalHandler::handler_list[ TSignalHandler::MAX_SIGNAL_ENTRY ];

Tvoid TSignalHandler::Initialize()
{
  for ( Tint i = 0; i < MAX_SIGNAL_ENTRY; i ++ )
    handler_list[ i ] = 0;
  return;
}

Tvoid TSignalHandler::signal_ucr( Tint sig )
{
  if ( client )
    client -> CatchSignal( sig );
  return;
}

Tint TSignalHandler::Wait()
{
  return pause();
}
