// ============================================================================
//  $Id: TUtilities.cc,v 1.3 2003/10/10 11:50:15 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TUtilities.cc,v $
//  Revision 1.3  2003/10/10 11:50:15  goiwai
//  ʤ󤫥ѥˤꤹǥХåեĹûޤ.ʤǤ
//
//  Revision 1.2  2003/10/10 09:37:22  goiwai
//  Хåեѹޤ.
//
//  Revision 1.1  2003/10/06 16:34:36  goiwai
//  ǡѴɽ,ˤ˻ѤؿΤΥåѡ饹
//  Ǥ.CΥ饤֥ؿǡѤǤޤ.
//
// ============================================================================
#include "TUtilities.hh"
#include "TRegularExpression.hh"

static const Tsize_t _buflen = 127;

Tstring TUtilities::ConvertIntegerToString( Tint i, Tint digits )
{
  static Tchar buf[ _buflen + 1 ];
  Tostrstream os( buf, _buflen );

  if ( i >= 0 ) {
    os << setfill( '0' ) << setiosflags( Tios::right ) << setw( digits );
    os << i << Tends;
    Tstring s = os.str();
    return s;
  } else {
    os << i << Tends;
    Tstring s = os.str();
    Tint nzero = digits - s.size();
    if ( nzero > 0 ) {
      s.insert( 1, nzero, '0' );
    }
    return s;
  }
}

Tstring TUtilities::ConvertLongToString( Tlong l, Tint digits )
{
  static Tchar buf[ _buflen + 1 ];
  Tostrstream os( buf, _buflen );

  if ( l >= 0 ) {
    os << setfill( '0' ) << setiosflags( Tios::right ) << setw( digits );
    os << l << Tends;
    Tstring s = os.str();
    return s;
  } else {
    os << l << Tends;
    Tstring s = os.str();
    Tint nzero = digits - s.size();
    if ( nzero > 0 ) {
      s.insert( 1, nzero, '0' );
    }
    return s;
  }
}

Tstring TUtilities::ConvertUnsignedLongToString( TUlong ul, Tint digits )
{
  static Tchar buf[ _buflen + 1 ];
  Tostrstream os( buf, _buflen );

  if ( ul >= 0 ) {
    os << setfill( '0' ) << setiosflags( Tios::right ) << setw( digits );
    os << ul << Tends;
    Tstring s = os.str();
    return s;
  } else {
    os << ul << Tends;
    Tstring s = os.str();
    Tint nzero = digits - s.size();
    if ( nzero > 0 ) {
      s.insert( 1, nzero, '0' );
    }
    return s;
  }
}

Tstring TUtilities::ConvertDoubleToString( Tdouble d, Tint precision )
{
  static Tchar buf[ _buflen + 1 ];
  Tostrstream os( buf, _buflen );

  os << setprecision( precision ) << d << Tends;
  Tstring s = os.str();
  return s;
}

Tstring TUtilities::ConvertFloatToString( Tfloat f, Tint precision )
{
  return ConvertDoubleToString( (Tdouble)f, precision );
}

Tbool TUtilities::FileExist( const Tstring& filename )
{
  if ( access( filename.c_str(), F_OK ) == 0 ) {
    return Ttrue;
  } else {
    return Tfalse;
  }
}

Tint TUtilities::ConvertStringToInteger( const Tstring& nptr, Tchar** endptr, Tint base )
{
  return (Tint)strtol( nptr.c_str(), endptr, base );
}

Tdouble TUtilities::ConvertStringToDouble( const Tstring& nptr, Tchar** endptr )
{
  return strtod( nptr.c_str(), endptr );
}

Tvoid TUtilities::ShowBitPattern( Tint bit )
{
  Tint nbit = Tsizeof( bit ) * 8;
  for ( Tint i = nbit; i > 0; i -- ) {
    Tcout << ( ( bit >> i - 1 ) & 0x01 );
  }
  Tcout << Tendl;
  return;
}

TstringList TUtilities::Split( const Tstring& source, const Tstring& pattern, Tint pos )
{
  TRegularExpression regex( pattern );
  return regex.Split( source, pos );
}

TintList TUtilities::Indexes( const Tstring& source, const Tstring& pattern, Tint pos )
{
  TRegularExpression regex( pattern );
  return regex.Indexes( source, pos );
}

TintList TUtilities::Sizes( const Tstring& source, const Tstring& pattern, Tint pos )
{
  TRegularExpression regex( pattern );
  return regex.Sizes( source, pos );
}

Tstring TUtilities::Substitute( const Tstring& source, const Tstring& pattern, const Tstring& substr, Tint pos )
{
  TRegularExpression regex( pattern );
  return regex.Substitute( source, substr, pos );
}

Tstring TUtilities::SubstituteAll( const Tstring& source, const Tstring& pattern, const Tstring& substr, Tint pos )
{
  TRegularExpression regex( pattern );
  return regex.SubstituteAll( source, substr, pos );
}

Tbool TUtilities::IsMatch( const Tstring& source, const Tstring& pattern, Tbool igcase, Tint pos )
{
  TRegularExpression regex( pattern );
  if ( igcase == Ttrue ) {
    regex.IgnoreCase();
  }
  return regex.IsMatch( source, pos );
}

Tstring TUtilities::GetBaseName( const Tstring& path )
{
  Tsize_t n = path.size();
  Tchar* buf = new Tchar[ path.size() + 1 ];
  path.copy( buf, n );
  Tstring base = basename( buf );
  delete [] buf;
  return base;
}

Tstring TUtilities::GetDirectoryName( const Tstring& path )
{
  Tsize_t n = path.size();
  Tchar* buf = new Tchar[ path.size() + 1 ];
  path.copy( buf, n );
  Tstring dir = dirname( buf );
  delete [] buf;
  return dir;
}
