// =====================================================================
//  $Id: omemory.cc,v 1.3 2003/10/06 04:03:39 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: omemory.cc,v $
//  Revision 1.3  2003/10/06 04:03:39  goiwai
//  TArgumentѤ褦ƤΥץޤ.
//
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectSharedMemory.hh"
#include "TBenchmark.hh"
#include "TDataRecord.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TOption opev( "number-of-events", 1 );
  TArgument arg( argc, argv, TOptionTable( &opev ) );

  Tint nevent = 10;
  if ( arg.HasOption( opev ) ) {
    nevent = arg.GetIntegerParameter( opev );
  }

  TOutputObjectSharedMemory omemory;
  Tint datasize = 0;
  Tint nevents = 0;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record;
    record.Test( i );
    omemory << record;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << omemory.GetTotalDataSize();
  Tcout << " byte data has been written." << Tendl;

  return 0;
}
