// ============================================================================
//  $Id: AsoReadFileCommand.cc,v 1.1.1.1 2002/12/04 23:47:38 iwai Exp $
//  $Name:  $
// ============================================================================
#include "AsoReadFileCommand.hh"
#include "TInputObjectFile.hh"
#include "TDataRecord.hh"

static const Tstring name = "aso-read";
static const Tstring desc = "TDataRecordΥ֥Ȥե뤵줿ե򳫤ƤƤפޤ\nADѴ줿ǡ4ӥåȥեȤ졢12ӥåȤƤɽޤ\nexample> aso-read filename.obj";

AsoReadFileCommand::AsoReadFileCommand()
  : TCommand( name, desc )
{;}

AsoReadFileCommand::~AsoReadFileCommand()
{;}

Tvoid AsoReadFileCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() != 1 ) {
    ShowCommandDetail();
    return;
  }

  const Tstring filename = arguments[ 0 ];
  TInputObjectFile* ifile = new TInputObjectFile( filename );

  

  Tint counter = 0;
  Tint datasize1 = 0;
  Tint datasize2 = 0;

  TDataRecord record;

  while ( ( ifile -> ReadData( record ) ) != 0 ) {

    TDataRecord newrecord;

    TDataSection sec0 = record[ 0 ];  // counter/clock
    TDataSection sec1 = record[ 1 ];  // AD data

    TDataSegment seg = sec1[ 0 ];
    TDataElement ele = seg[ 0 ];

    const Tint narray = ele.GetNumberOfPrimitives();
    TUshort* data = (TUshort*)( ele.GetData() );

    TUshort* newdata = new TUshort[ narray ];
    TUshort databuf;

    for ( Tint n = 0; n < narray; n ++ ) {
      databuf = *data;
      databuf = databuf >> 4;
      newdata[ n ] = databuf;
      data ++;
    }

    TDataElement newele =
      TDataElement( newdata, ele.GetElementType(), ele.GetID(), narray );

    delete [] newdata;

    seg.clear();
    seg.push_back( newele );
    sec1.clear();
    sec1.push_back( seg );

    newrecord.push_back( sec0 );
    newrecord.push_back( sec1 );


    Tcout << newrecord << Tendl;

    datasize1 += newrecord.GetDataSize();
    datasize2 += ifile -> GetDataSize();
    counter ++;
  }

  Tcout << Tendl;
  Tcout << Ttab << counter << " event, ";
  Tcout << datasize1 << Tslash << datasize2;
  Tcout << " byte data has been read from " << filename << Tendl;
  Tcout << Tendl;

  delete ifile;

  return;
}
