// ============================================================================
//  $Id: BtExtractorAdc.cc,v 1.2 2002/12/07 23:06:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtExtractorAdc.hh"
#include "TInputObjectFile.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "parameter.h"
#include "BtDummyRunAction.hh"
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"

static const Tstring name = "ADC-CH0";
static const Tobject_t type = tObject1DHistogram;
static const Tint nevents = 1;
static const Tint usec = 1000000;

BtExtractorAdc::BtExtractorAdc()
  : TExtractor( name, type, nevents, usec )
{;}

BtExtractorAdc::~BtExtractorAdc()
{;}

Tvoid BtExtractorAdc::Extract()
{
  TDataRecord record;
  TDataElement element;
  Tint datasize = 0;

  BtDummyRunAction* action =
    (BtDummyRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TInputObjectFile* ifile = action -> GetInputFile();

  do {
    datasize = ifile -> ReadData( record );

    if ( datasize == 0 ) {
      ifile -> SetOffset( ifile -> GetTotalDataSize(), SEEK_SET );
      sleep( 1 );
      continue;
    }

    element = FindDataElement( record, 1234, 5678, 0 );
  } while ( element.GetID() == tIDunknown || DoesDataFound() == Tfalse );
  //DoesDataFound() ǤۤȤϤϤʤɤ

  TDataElementList list;
  list.push_back( element );
  FillMatrix( list );

  return;
}
