/* MushConsole.cc */
/* Created by Enomoto Sanshiro on 29 November 2000. */
/* Last updated by Enomoto Sanshiro on 29 November 2000. */


#include <cstdio>
#include <cstring>
#include <iostream>
#include <string>
#include "MushDefs.hh"
#include "MushConfig.hh"
#include "MushConsole.hh"


using namespace std;


#if USE_READLINE
extern "C" {
#include <readline/readline.h>
#include <readline/history.h>
};
#endif

static const int MaxLineLength = 256;
static char InputBuffer[MaxLineLength];


TMushConsole::TMushConsole(void)
{
    _Prompt = 0;
}

TMushConsole::~TMushConsole()
{
    if (_Prompt != 0) {
	free(_Prompt);
    }
}

void TMushConsole::SetPrompt(const char* Prompt)
{
    _Prompt = strdup(Prompt);
}

bool TMushConsole::GetLine(string& Line)
{
    bool Result;
    if (Result = GetLineTo(InputBuffer, MaxLineLength)) {
	Line = InputBuffer;
    }

    return Result;
}

bool TMushConsole::GetLineTo(char* Buffer, size_t MaxSize)
{
    if (_Prompt != 0) {
	cout << _Prompt << flush;
    }

    return (bool) cin.getline(Buffer, MaxSize, '\n');
}



TMushReadlineConsole::TMushReadlineConsole(void)
{
#if USE_READLINE
    // disables <TAB> completion //
    rl_bind_key('\t', (Function*) rl_insert); 
#endif
}

TMushReadlineConsole::~TMushReadlineConsole()
{
}

bool TMushReadlineConsole::GetLine(string& Line)
{
#if USE_READLINE
    char* Buffer = readline(_Prompt);     // EOF returns NULL
    if (Buffer != 0) {
	if (Buffer[0] != '\0') {
	    add_history(Buffer);
	}
	Line = Buffer;
	free(Buffer);
    }

    return (Buffer != 0);

#else
    return TMushConsole::GetLine(Line);
#endif
}

bool TMushReadlineConsole::GetLineTo(char* Buffer, size_t MaxSize)
{
#if USE_READLINE
    char* Line = readline(_Prompt);     // EOF returns NULL
    if (Line != 0) {
	if (Line[0] != '\0') {
	    add_history(Line);
	}
	strncpy(Buffer, Line, MaxSize - 1);
	free(Line);
    }

    return (Line != 0);
#else
    return TMushConsole::GetLineTo(Buffer, MaxSize);
#endif
}

