/* MushSocket.hh */
/* Created by Enomoto Sanshiro on 21 January 1998. */
/* Last updated by Enomoto Sanshiro on 19 November 1999. */


#ifndef __MushSocket_hh__
#define __MushSocket_hh__

#include "MushDefs.hh"


class TMushSocket {
  public:
    enum TSocketStatus {
	ssInitial, ssCreated, ssBinded, ssListening, ssOpened
    };
  public:
    TMushSocket(void);
    virtual ~TMushSocket();
    virtual TSocketStatus Status(void) const;
    virtual void Open(void) throw(TSystemCallException) = 0;
    virtual void Close(void) = 0;
    virtual int Send(const void *Buffer, size_t Length) throw(TSystemCallException);
    virtual int Receive(void *Buffer, size_t Length) throw(TSystemCallException);
    virtual bool IsServer(void) const = 0;
    virtual int FileDescriptor(void) const;
  protected:
    TSocketStatus _SocketStatus;
    int _ConnectSocket;
};


class TMushServerSocket: virtual public TMushSocket {
  public:
    TMushServerSocket(void);
    virtual ~TMushServerSocket();
    virtual void EnableLocalAddressReuse(void) throw(TSystemCallException);
    virtual void Open(void) throw(TSystemCallException);
    virtual void Close(void);
    virtual bool IsServer(void) const {return true;}
  public:
    virtual void Bind(void) throw(TSystemCallException) = 0;
    virtual void Listen(int MaxNumberOfConnections = 1) throw(TSystemCallException);
    virtual void Accept(void) throw(TSystemCallException) = 0;
  protected:
    int _ListenSocket;
};


class TMushClientSocket: virtual public TMushSocket {
  public:
    TMushClientSocket(void);
    virtual ~TMushClientSocket();
    virtual void Open(void) throw(TSystemCallException);
    virtual void Close(void);
    virtual bool IsServer(void) const {return false;}
  public:
    virtual void Connect(void) throw(TSystemCallException) = 0;
};

#endif
