/* MushSocketSelector.hh */
/* UNIX System Call Interface (select(3N) or poll(3N)) */
/* Created by Enomoto Sanshiro on 4 December 1999. */
/* Last updated by Enomoto Sanshiro on 4 December 1999. */


#ifndef __MushSocketSelector_hh__
#define __MushSocketSelector_hh__


// If you prefer select(3N) to poll(3N), uncomment the following line
//#define USE_SELECT


#ifdef USE_SELECT
#error "select() has not been supported yet."
#endif

#include <map>
#include <poll.h>
#include "MushSocket.hh"


class TMushSocketSelector {
  public:
    enum TSocketEvent {
	seDataArrived,
	seHungUp,
	seTimedOut,
	seInterrupted,
	seOthers
    };
  public:
    TMushSocketSelector(void);
    virtual ~TMushSocketSelector();
    virtual void AddSocket(TMushSocket* Socket);
    virtual void RemoveSocket(TMushSocket* Socket);
    virtual std::pair<TMushSocket*, TSocketEvent> WaitEvent(int TimeOut_ms = 0) throw(TSystemCallException);
  protected:
    virtual void ResizeFdTable(int NewCapacity);
  protected:
    std::map<int, TMushSocket*> _SocketTable;
    int _NumberOfSockets;
    pollfd* _PollFdSet;
    int _PollFdSetCapacity;
    int _NextPolledFdIndex;
};


#endif
