#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "httpdown.h"

extern int ReportLevel;

// ѥ
void parsepath(char *path)
{
    // ̾ޤǤ򥹥å
    char *p,*q;
    p=strstr(path,"://");
    if(p==NULL) return;
    path=strchr(p+3,'/');
    if(path==NULL) return;

    char *dp=strdup(path);

    int f=0;

    //   \ ִ
    p=dp;
    while(*p)
      {
	  if(*p=='\\')
	    *p='/';
	  p++;
      }

    //   ./ 
    p=dp;
    while(1)
      {
	  p=strstr(p,"/./");
	  if(p==NULL) break;
	  strncpy(p+1,"  ",2);
      }

    //   ../ Ģäˤ
    p=dp;
    while(1)
      {
	  p=strstr(p,"/../");
	  if(p==NULL) break;
	  
	  *p='\0';
	  q=strrchr(dp,'/');
	  if(q!=NULL)         // "/../kkk.html" äƤ줿ȤΤ
	    {
		*p='/';
		*q=' ';
		while(*q!='/')
		  {
		      *q=' ';
		      q++;
		  }
	    }
	  strncpy(p,"   ",3);
      }
    q=dp;
    p=path;
    while(*q)
      {
	  *p = *q;
	  if(*q != ' ') p++;
	  q++;
      }
    *p='\0';

    free(dp);
}

struct SDatas
{
    int flag;
    int retry;
    char *url;
};

SDatas sdata[MAXSData];
int sdatac=0;
int procstart=0;
int procend=0;

inline strncmp1(char *s1,char *s2)
{
    return strncmp(s1,s2,strlen(s1));
}

void AddSData(char *name,int flag)
{
    if(sdatac==MAXSData) 
      {
	  if(ReportLevel>=0)
	    fprintf(Err,"Gaberge Collect-------------------------\n");
	  SortSData();
      }
    if(sdatac==MAXSData)
      {
	  fprintf(Err,"Please change MAXSData in httpdown.h and recompile\n");
	  Termination=1;
	  return;        // ̵
      }

//    printf("%s  \n",name);
    parsepath(name);
    // ŬΥå
    int f=0;
    if((!URLMatch.IsNULL())&&(flag==URLFind))
      {
	  if(!URLMatch.IsMatch(name))
	    flag=URLCannot;
      }

    //    printf("%s\n",name);
    sdata[sdatac].url=strdup(name);
    sdata[sdatac].flag=flag;
    sdata[sdatac].retry=0;
    sdatac++;
}

static int sort_func(const void *_a,const void *_b)
{
    SDatas *a=(SDatas *)_a;
    SDatas *b=(SDatas *)_b;
    int s;
    s=strcmp(a->url,b->url);
    if(s==0) return (b->flag)-(a->flag);
    else return s;
}

static int sort_func_gc(const void *_a,const void *_b)
{
    SDatas *a=(SDatas *)_a;
    SDatas *b=(SDatas *)_b;
    int s;
    s=(b->flag)-(a->flag);
    if(s==0) return strcmp(a->url,b->url);
    return s;
}

// ¤ٴͭʤΤ
int SortSData(void)
{
    // ʤ٤
    qsort(sdata,sdatac,sizeof(SDatas),sort_func);
    
    int i,l;
    l= -1;
    for(i=0;i<sdatac;i++)
      {
	  if((i>0)&&(strcmp(sdata[i].url,sdata[i-1].url)==0))
	    {
		sdata[i].flag= URLGarbage;
		// ǤˤǤƤΤȤ֤ä
		// ߤȤ
		continue;
	    }

	  // Ǥ˲Ѥ
	  if(sdata[i].flag!=URLFind) l=i;

	  // 󸫤Ĥä
	  if(sdata[i].flag==URLFind) 
	    {
/*		if((i>0)&&(strcmp(sdata[i].url,sdata[i-1].url)==0))
		  sdata[i].flag= URLGarbage;
		      // ǤˤǤƤΤȤ֤ä
		      // ߤȤ*/
		if(l!= -1)
		  {
		      if(strcmp(sdata[i].url,sdata[l].url)==0)
			sdata[i].flag= URLGarbage;
		      // Ǥ˲褵줿ΤȤ֤ä
		      // ߤȤ
		  }
	    }
      }

//    PrintSData();

    // ߤ򤪤
    qsort(sdata,sdatac,sizeof(SDatas),sort_func_gc);
    
//    PrintSData();

    procstart=-1;
    int ll=sdatac;
    for(i=0;i<sdatac;i++)
      {
	  if(sdata[i].flag== URLGarbage) 
	    {
		if(ll==sdatac)
		  ll=i;   // ü
		free(sdata[i].url);
		sdata[i].url=NULL;
	    }
	  if(sdata[i].flag>URLFind) procstart=i;
      }
    procstart++;
    sdatac=ll;
    procend=sdatac;

    return sdatac-procstart;   // ̤ο֤
}

static int retrycount=0;

// Ƶ٥򤢤:Ȥȥȥ饤
void NextLevel(int retry)
{
    int i;
    if(retry<1)
      retry=1;
    SortSData();
    for(i=0;i<sdatac;i++)
      if(sdata[i].flag==URLFind)
	sdata[i].retry=retry;
    retrycount=0;
}


char *NextSData(void)
{
    while(((sdata[procstart].flag!=URLFind) || (sdata[procstart].retry<1))
	  && (procstart<procend))
      procstart++;

    if(procstart==procend) 
      {
	  SortSData();             // ̤ä饽: procstart Ȥ
	  retrycount++;            // ʤ
	  if(ReportLevel>=0)
	    printf("<retry cycle %d>\n",retrycount);
      }
    // ⤦
    while(((sdata[procstart].flag!=URLFind) || (sdata[procstart].retry<1))
	  && (procstart<procend))
      procstart++;

    if(procstart==procend)        // ۤȤˡ⤦ʤ
      return NULL;

    sdata[procstart].retry--; 
    if(sdata[procstart].retry==0)
      sdata[procstart].flag= URLCannot;    // ȥ饤ĤäƤʤȤߤˤʤ
    // ٻȤä餴ߤȤ
    // ɬפʤΤϺϿ
    char *r=sdata[procstart].url;
    procstart++;
    return r;
}

void PrintSData(void)
{
    int i;
    printf("num:%d\n",sdatac);
    for(i=0;i<sdatac;i++)
      {
	  printf("%3d  %c %s\n",i,URLFlags[sdata[i].flag-URLGarbage],
		 sdata[i].url);
      }
}


void FileSData(FILE *fp)
{
    int i;
    SortSData();
    for(i=0;i<sdatac;i++)
      {
	  if(sdata[i].flag==URLTerminated)
	    fprintf(fp,"r %s\n",sdata[i].url);
	  else if(sdata[i].flag==URLCannot)
	    fprintf(fp,"E %s\n",sdata[i].url);
	  else if(sdata[i].flag==URLFind)
	    fprintf(fp,"F %s\n",sdata[i].url);
	  else if(sdata[i].flag==URLRecursive)
	    fprintf(fp,"D %s\n",sdata[i].url);
      }
}
