#include <stdio.h>
#include <string.h>

// ե

inline int GetChar(void)
{
    char buff[100];
    fgets(buff,100,stdin);
    return buff[0];
}

inline void GetS(char *s,int l)
{
    fgets(s,l,stdin);
    if(s[strlen(s)-1]==0x0a)
      s[strlen(s)-1]='\0';
    if(s[strlen(s)-1]==0x0d)
      s[strlen(s)-1]='\0';
}

int CreateDefinitions(char *filename)
{
    char c;
    char buff[500];
    int i;

    printf("Do you want to create new definition file? (y/[n])>");
    fflush(stdout);
    if(GetChar()!='y')
      return 0;
    
    FILE *fp;
    fp=fopen(filename,"r");
    if(fp!=NULL)
      {
	  printf("file '%s' already exists\n",filename);
	  fclose(fp);
	  return 0;
      }
    fp=fopen(filename,"w");
    if(fp==NULL)
      {
	  printf("cannot create file '%s'.\n",filename);
	  return 0;
      }

    fprintf(fp,"# definition file for httpdown ver 3.x\n");
    fprintf(fp,"#   this file is generated by httpdown:CreateDefinition\n");
    fprintf(fp,"\n# following lines determine where to access first\n");
    fprintf(fp,"# (you can use multiple 'start' URL)\n\n");
    
    printf("Please input URL where to start recursive transfer(necessary)\n    ->");
    GetS(buff,500);
    if(strlen(buff)<3)
      fprintf(fp,"# start http://mechatro1.mech.tohoku.ac.jp/\n\n");
    else
      fprintf(fp,"start %s\n\n",buff);


    fprintf(fp,"# following lines determine access matching pattern.\n");
    fprintf(fp,"# if URL found by Httpdown have same strings, use it\n");
    fprintf(fp,"# ex: 'http://aaa.com/dir1/dir2/file.html' matches to\n");
    fprintf(fp,"#           'http://aaa.com/dir1/'.\n");
    fprintf(fp,"#  this rule is not necessary. you can use plural 'allow's\n\n");
    printf("Please input URL match pattern (not necessary)\n    ->");
    GetS(buff,500);
    if(strlen(buff)<3)
      fprintf(fp,"# allow http://mechatro1.mech.tohoku.ac.jp/\n\n");
    else
      fprintf(fp,"allow %s\n\n",buff);
    

    fprintf(fp,"# following command 'level' determines how many times\n");
    fprintf(fp,"# recursive get\n\n");

    printf("Please input Transfer-level (not necessary: default=5)\n    ->");
    GetS(buff,500);
    if(sscanf(buff,"%d",&i)!=1)
      i=0;
    if(i<1)
      fprintf(fp,"# level 5\n\n");
    else
      fprintf(fp,"level %d\n\n",i);


    fprintf(fp,"# following command 'reportlevel' determines an extent of report\n");
    fprintf(fp,"# 0 means quiet, larger than 10 means debug level\n\n");
    fprintf(fp,"# reportlevel 2\n\n");


    fprintf(fp,"# followings are ftp definitions\n");
    fprintf(fp,"# if you use ftp:// these will be necessary\n\n");
    printf("Please input your e-mail address (not necessary)\n    ->");
    GetS(buff,500);
    if(strlen(buff)<3)
      {
	  fprintf(fp,"# ftpuser anonymous\n");
	  fprintf(fp,"# ftppass yourid@yourhost.local.country\n\n");
      }
    else
      {
	  fprintf(fp,"ftpuser anonymous\n",buff);
	  fprintf(fp,"ftppass %s\n\n",buff);
      }
    

    fprintf(fp,"# following command determines ID and password for\n");
    fprintf(fp,"# HTTP-Authorization, account for password-locked page\n");
    fprintf(fp,"# write id and password coupled with ':' without space\n\n");
    fprintf(fp,"# httpauth yourid:yourpass\n");

    printf("program genarated definition file '%s' from your answers.\n",
	   filename);
    printf("please check and edit this file to taste.\n");
    printf("then please restart HTTPDOWN\n");
    fclose(fp);
    return 1;
}
     
	  
     
	  
