// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TDataElement.hh"
#include "TOutputObjectSocket.hh"
#include "TModule.hh"
#include "TOutputObjectFile.hh"

TDataElement::TDataElement( Telement_t type, Tint id )
  : TStreamableObject( tDataElement, id ), 
    theData( 0 ), theElementType( type ), theNumberOfPrimitives( 1 )
{;}

TDataElement::TDataElement( Tvoid* data, Telement_t type, Tint id )
  : TStreamableObject( tDataElement, id ), 
    theElementType( type ), theNumberOfPrimitives( 1 )
{
  allocateDataSpace( data );
}

TDataElement::~TDataElement()
{
  freeDataSpace();
}

Tvoid TDataElement::Print( Tostream& tos )
{
  Tstring head = Twspace + Twspace + Twspace + "* Data Element, ";
  tos << head << "ID: " << theID;
  tos << Twspace << "Primitives: " << theNumberOfPrimitives;
  tos << Twspace << "Type: " << theElementType;

  switch ( theElementType ) {
    case tTypeString:
      tos << "(Tstring)" << Twspace << "Data: ";
      tos << *( (Tstring*)theData ) << Tendl;
      break;
    case tTypeDouble:
      tos << "(Tdouble)" << Twspace << "Data: ";
      tos << *( (Tdouble*)theData ) << Tendl;
      break;
    case tTypeInt:
      tos << "(Tint)" << Twspace << "Data: ";
      tos << *( (Tint*)theData ) << Tendl;
      break;
    case tTypeUnknown:
    case tTypeObject:
    case tTypeFloat:
    default:
      tos << "(Unknown)" << Twspace << "Data: ";
      tos << "unknown(or undefined) data ..." << Tendl;
      break;
  }

  return;
}

Tvoid TDataElement::freeDataSpace()
{
  if ( theData != 0 ) {
    switch ( theElementType ) {
      case tTypeString:
	delete (Tstring*)( theData );
	break;
      case tTypeDouble:
	delete (Tdouble*)( theData );
	break;
      case tTypeInt:
	delete (Tint*)( theData );
      case tTypeUnknown:
      case tTypeObject:
      case tTypeFloat:
      default:
	break;
    }
  }
  theNumberOfPrimitives = 1;
  return;
}

Tvoid TDataElement::allocateDataSpace( Tvoid* data )
{
  switch ( theElementType ) {
    case tTypeString:
      theData = new Tstring( *( (Tstring*)(data) ) );
      theNumberOfPrimitives += ( ( (Tstring*)theData ) -> size() );
      break;
    case tTypeDouble:
      theData = new Tdouble( *( (Tdouble*)(data) ) );
      break;
    case tTypeInt:
      theData = new Tint( *( (Tint*)(data) ) );
      break;
    case tTypeUnknown:
    case tTypeObject:
    case tTypeFloat:
    default:
      break;
  }
  return;
}

Tint TDataElement::WriteData( TOutputObjectStream* output )
{
  Tsize_t size = 0;
  Tstream_t streamtype = output -> GetStreamType();

  if ( streamtype == tFileStream ) {
    TOutputObjectFile* ofile = (TOutputObjectFile*)output;
    static const Tsize_t nmemb = 1;
    size += fwrite( this, Tsizeof( *this ), nmemb, ofile -> GetFileStream() ) * Tsizeof( *this );

    switch ( theElementType ) {
      case tTypeString:
	Tchar c;
	for ( Tint i = 0; i < theNumberOfPrimitives; i ++ ) {
	  if ( i == theNumberOfPrimitives - 1 )
	    c = '\0';
	  else
	    c = ( (Tstring*)theData ) -> at( i );
	  size += fwrite( &c, Tsizeof( Tchar ), nmemb, 
			  ofile -> GetFileStream() ) * Tsizeof( Tchar );
	}
	break;
      case tTypeDouble:
	Tdouble d;
	d = *( (Tdouble*)theData );
	size += fwrite( &d, Tsizeof( Tdouble ), nmemb, 
			ofile -> GetFileStream() ) * Tsizeof( Tdouble );
	break;
      case tTypeInt:
	Tint i;
 	i = *( (Tint*)theData );
 	size += fwrite( &i, Tsizeof( Tint ), nmemb, 
			ofile -> GetFileStream() ) * Tsizeof( Tint );
	break;
      case tTypeUnknown:
      case tTypeObject:
      case tTypeFloat:
      default:
	break;
    }

  } else if ( streamtype == tSocketStream ) {

    TOutputObjectSocket* osocket = (TOutputObjectSocket*)output;
    Tsize_t s = 0;
    s = (Tsize_t)send( osocket -> GetFileDescriptor(), this, Tsizeof( *this ), 0 );

    if ( s != Tsizeof( *this ) ) {
      perror( __FILE__ );
      exit( -errno );
    } else {
      size += s;
    }

    switch ( theElementType ) {
      case tTypeString:
	Tchar c;
	for ( Tint i = 0; i < theNumberOfPrimitives; i ++ ) {
	  if ( i == theNumberOfPrimitives - 1 )
	    c = '\0';
	  else
 	    c = ( (Tstring*)theData ) -> at( i );
	  s = send( osocket -> GetFileDescriptor(), &c, Tsizeof( Tchar ), 0 );


	  if ( s != Tsizeof( Tchar ) ) {
	    perror( __FILE__ );
	    exit( -errno );
	  } else {
	    size += s;
	  }
 	}
	break;
      case tTypeDouble:
	Tdouble d;
	d = *( (Tdouble*)theData );
	s = send( osocket -> GetFileDescriptor(), &d, Tsizeof( Tdouble ), 0 );
	if ( s != Tsizeof( Tdouble ) ) {
	  perror( __FILE__ );
	  exit( -errno );
	} else {
	  size += s;
	}
	break;
      case tTypeInt:
	Tint i;
 	i = *( (Tint*)theData );
	s = send( osocket -> GetFileDescriptor(), &i, Tsizeof( Tint ), 0 );
	if ( s != Tsizeof( Tint ) ) {
	  perror( __FILE__ );
	  exit( -errno );
	} else {
	  size += s;
	}
	break;
      case tTypeUnknown:
      case tTypeObject:
      case tTypeFloat:
      default:
	break;
    }

  } else {
    //
    //
    ;
  }

  return( (Tint)size );
}

Tint TDataElement::GetDataSize()
{
  Tsize_t size = Tsizeof( *this );

  switch ( theElementType ) {
    case tTypeString:
      size += ( Tsizeof( Tchar ) ) * theNumberOfPrimitives;
      break;
    case tTypeDouble:
      size += Tsizeof( Tdouble );
      break;
    case tTypeInt:
      size += Tsizeof( Tint );
      break;
    case tTypeUnknown:
    case tTypeObject:
    case tTypeFloat:
    default:
      break;
  }

  return( (Tint)size );
}
