// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TDATAELEMENT_HH
#define __TDATAELEMENT_HH

#include "TGlobals.hh"
#include "TStreamableObject.hh"

class TOutputObjectStream;
class TModule;

class TDataElement
  : public TStreamableObject
{

  private:
    Tvoid* theData;
    Telement_t theElementType;
    Tint theNumberOfPrimitives;

  public:
    TDataElement( Tvoid* data, Telement_t type, Tint id = tIDunknown );
    TDataElement( Telement_t type, Tint id = tIDunknown );
    ~TDataElement();

  public:
    Tint WriteData( TOutputObjectStream* output );
    Tint GetDataSize();
    Tvoid Print( Tostream& tos = Tstd::Tcout );

  public:
    inline Tvoid* GetData() const;
    inline Tvoid SetData( Tvoid* data );
    inline Telement_t GetElementType() const;
    inline Tvoid SetElementType( Telement_t elementtype );
    inline Tint GetNumberOfPrimitives() const;
    inline Tvoid SetNumberOfPrimitives( Tint nprimitives );

    inline Tvoid FillData( Tvoid* data, Telement_t elementtype );
    inline Tvoid FillData( Tvoid* data );

  private:
    Tvoid freeDataSpace();
    Tvoid allocateDataSpace( Tvoid* data );

};

inline Tvoid TDataElement::FillData( Tvoid* data, Telement_t elementtype )
{
  freeDataSpace();
  theElementType = elementtype;
  allocateDataSpace( data );
  return;
}

inline Tvoid TDataElement::FillData( Tvoid* data )
{
  SetData( data );
  return;
}

inline Tvoid* TDataElement::GetData() const
{
  return( theData );
}

inline Tvoid TDataElement::SetData( Tvoid* data )
{
  FillData( data, theElementType );
  return;
}

inline Telement_t TDataElement::GetElementType() const
{
  return( theElementType );
}

inline Tvoid TDataElement::SetElementType( Telement_t elementtype )
{
  theElementType = elementtype;
  return;
}

inline Tint TDataElement::GetNumberOfPrimitives() const
{
  return( theNumberOfPrimitives );
}

inline Tvoid TDataElement::SetNumberOfPrimitives( Tint nprimitives )
{
  theNumberOfPrimitives = nprimitives;
  return;
}

#endif
