// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TDataSection.hh"
#include "TOutputObjectStream.hh"
#include "TOutputObjectFile.hh"
#include "TOutputObjectSocket.hh"

TDataSection::TDataSection( Tint id, Tint capacity )
  : TStreamableObject( tDataSection, id ),
    TDataSegmentList( capacity, tDefaultReallocationParameter )
{;}

TDataSection::~TDataSection()
{;}

Tvoid TDataSection::Print( Tostream& tos )
{
  Tstring head = Twspace + "* Data Section, ";
  tos << head << "ID: " << theID;
  tos << Twspace << "Capacity: " << theCapacity;
  tos << Twspace << "Entry: " << theNumberOfEntries << Tendl;

  for ( Tint i = 0; i < theNumberOfEntries; i ++ )
    theObjects[ i ] -> Print( tos );

  return;
}

Tint TDataSection::GetDataSize()
{
  Tsize_t total = Tsizeof( *this );
  for ( Tint i = 0; i < theNumberOfEntries; i ++ )
    total += (Tsize_t)( theObjects[ i ] -> GetDataSize() );

  return( (Tint)total );
}

Tint TDataSection::WriteData( TOutputObjectStream* output )
{
  Tstream_t streamtype = output -> GetStreamType();
  Tsize_t size = 0;
  if ( streamtype == tFileStream ) {
    static const Tsize_t nmemb = 1;
    TOutputObjectFile* ofile = (TOutputObjectFile*)output;
    size += fwrite( this, Tsizeof(*this), nmemb, ofile -> GetFileStream() ) * Tsizeof(*this);
  } else if ( streamtype == tSocketStream ) {
    //now implement ....
    TOutputObjectSocket* osocket = (TOutputObjectSocket*)output;
    size += (Tsize_t)send( osocket -> GetFileDescriptor(), this, Tsizeof(*this), 0 );
  } else if ( streamtype == tSharedMemoryStream ) {
    ;
  } else {
    //
    //
    ;
  } 
  for ( Tint i = 0; i < theNumberOfEntries; i ++ )
    size += (Tsize_t)( theObjects[ i ] -> WriteData( output ) );
  return( (Tint)size );
}
