// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TDataSegment.hh"
#include "TOutputObjectStream.hh"
#include "TOutputObjectFile.hh"
#include "TOutputObjectSocket.hh"

TDataSegment::TDataSegment( Tint id, Tint capacity )
  : TStreamableObject( tDataSegment, id ),
    TDataElementList( capacity, tDefaultReallocationParameter )
{;}

TDataSegment::~TDataSegment()
{;}

Tvoid TDataSegment::Print( Tostream& tos )
{
  Tstring head = Twspace + Twspace + "* Data Segment, ";
  tos << head << "ID: " << theID;
  tos << Twspace << "Capacity: " << theCapacity;
  tos << Twspace << "Entry: " << theNumberOfEntries << Tendl;

  for ( Tint i = 0; i < theNumberOfEntries; i ++ )
    theObjects[ i ] -> Print( tos );

  return;
}

Tint TDataSegment::GetDataSize()
{
  Tsize_t total = Tsizeof( *this );
  for ( Tint i = 0; i < theNumberOfEntries; i ++ )
    total += (Tsize_t)( theObjects[ i ] -> GetDataSize() );
  return( (Tint)total );
}

Tint TDataSegment::WriteData( TOutputObjectStream* output )
{
  Tstream_t streamtype = output -> GetStreamType();
  Tsize_t size = 0;
  if ( streamtype == tFileStream ) {
    static const Tsize_t nmemb = 1;
    TOutputObjectFile* ofile = (TOutputObjectFile*)output;
    size += fwrite( this, Tsizeof(*this), nmemb, ofile -> GetFileStream() ) * Tsizeof(*this);
  } else if ( streamtype == tSocketStream ) {
    TOutputObjectSocket* osocket = (TOutputObjectSocket*)output;
    size += (Tsize_t)send( osocket -> GetFileDescriptor(), this, Tsizeof(*this), 0 );
  } else if ( streamtype == tSharedMemoryStream ) {
    ;
  } else {
    //
    //
    ;
  } 
  for ( Tint i = 0; i < theNumberOfEntries; i ++ )
    size += (Tsize_t)( theObjects[ i ] -> WriteData( output ) );
  return( (Tint)size );
}
