// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TINPUTOBJECTFILE_HH
#define __TINPUTOBJECTFILE_HH

#include "TGlobals.hh"
#include "TObjectFile.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;
class TDataFilter;

class TInputObjectFile
  : public TObjectFile, public TInputObjectStream
{

  public:
    TInputObjectFile( const Tstring& filename, const Tstring& mode = "r" );
    TInputObjectFile( TDataFilter* filter, const Tstring& filename, const Tstring& mode = "r" );
    ~TInputObjectFile();

  public:
    TStreamableObject* ReadData();
  
  private:
    TDataRecord* getDataRecord();
    TDataSection* getDataSection();
    TDataSegment* getDataSegment();
    TDataElement* getDataElement();

};

#endif
