// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TInputObjectSocket.hh"
#include "TDataFilter.hh"
#include "TStreamableObject.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"


TInputObjectSocket::TInputObjectSocket( Tint port )
  : TObjectSocket( port ), TInputObjectStream( tSocketStream ),
    theClient( -1 )
{
  initialize();
  Tcout << "now, waiting connection port:" << thePortNumber << " ..." << Tendl;
}

TInputObjectSocket::TInputObjectSocket( TDataFilter* filter, Tint port )
  : TObjectSocket( port ), TInputObjectStream( filter, tSocketStream ),
    theClient( -1 )
{
  initialize();
  Tcout << "now, waiting connection port:" << thePortNumber << " ..." << Tendl;
}

TInputObjectSocket::~TInputObjectSocket()
{;}

Tvoid TInputObjectSocket::initialize()
{
  theAddress.sin_family = PF_INET;
  theAddress.sin_addr.s_addr = htonl( INADDR_ANY );
  theAddress.sin_port = htons( (TUshort)thePortNumber );
  socklen_t server_len = (socklen_t)Tsizeof( theAddress );
  bind( theFileDescriptor, (struct sockaddr *)&theAddress, server_len );

  listen( theFileDescriptor, tDefaultBackLog );
  signal( SIGCHLD, SIG_IGN );
  signal( SIGPIPE, SIG_IGN );

  struct sockaddr_in client_address;
  socklen_t client_len;

  theClient = accept( theFileDescriptor, (struct sockaddr *)&client_address, &client_len );

  return;
}

TStreamableObject* TInputObjectSocket::ReadData()
{
  if ( HasFilter() )
    return( theDataFilter -> Analyze( this ) );

  theLastDataSize = theDataSize;
  theDataSize = 0;


  // seekʤΤǡǰʤ顢
  // ϥåȤФƤDataRecordǤǤ
  // Τʤ󤫹ͤޤ

  TStreamableObject* st = getDataRecord();

  return( st );
}

TDataRecord* TInputObjectSocket::getDataRecord()
{
  static const Tsize_t recordSize = Tsizeof( TDataRecord );
  TDataRecord* record = (TDataRecord*)( malloc( recordSize ) );

  if ( recv( theClient, record, recordSize, 0 ) != (Tint)recordSize )
    return( 0 );


  theDataSize += recordSize;
  Tint entries = record -> GetNumberOfEntries();
  Tint capacity = record -> GetCapacity();
  Tint id = record -> GetID();
  free( record );

  TDataRecord* r = new TDataRecord( id, capacity );
  for ( Tint i = 0; i < entries; i ++ )
    r -> Add( getDataSection() );

  return( r );
}

TDataSection* TInputObjectSocket::getDataSection()
{
  static const Tsize_t sectionSize = Tsizeof( TDataSection );
  TDataSection* section = (TDataSection*)( malloc( sectionSize ) );
  if ( recv( theClient, section, sectionSize, 0 ) != (Tint)sectionSize )
    return( 0 );

  theDataSize += sectionSize;
  Tint entries = section -> GetNumberOfEntries();
  Tint capacity = section -> GetCapacity();
  Tint id = section -> GetID();
  free( section );


  TDataSection* s = new TDataSection( id, capacity );
  for ( Tint i = 0; i < entries; i ++ )
    s -> Add( getDataSegment() );

  return( s );
}

TDataSegment* TInputObjectSocket::getDataSegment()
{
  static const Tsize_t segmentSize = Tsizeof( TDataSegment );
  TDataSegment* segment = (TDataSegment*)( malloc( segmentSize ) );
  if ( recv( theClient, segment, segmentSize, 0 ) != (Tint)segmentSize )
    return( 0 );

  theDataSize += segmentSize;
  Tint entries = segment -> GetNumberOfEntries();
  Tint capacity = segment -> GetCapacity();
  Tint id = segment -> GetID();
  free( segment );


  TDataSegment* s = new TDataSegment( id, capacity );
  for ( Tint i = 0; i < entries; i ++ )
    s -> Add( getDataElement() );

  return( s );
}

TDataElement* TInputObjectSocket::getDataElement()
{
  static const Tsize_t elementSize = Tsizeof( TDataElement );
  TDataElement* element = (TDataElement*)( malloc( elementSize ) );

  if ( recv( theClient, element, elementSize, 0 ) != (Tint)elementSize )
    return( 0 );

  theDataSize += elementSize;

  Telement_t eltype = element -> GetElementType();
  Tint id = element -> GetID();
  Tsize_t nprimitives = (Tsize_t)( element -> GetNumberOfPrimitives() );

  free( element );


  Tstring s;
  Tchar* c = new Tchar[ nprimitives ];
  Tint* i = new Tint[ nprimitives ];
  Tdouble* d = new Tdouble[ nprimitives ];
  Tvoid* data = 0;
  Tint sp = 0;

  switch ( eltype ) {
    case tTypeString:
      for ( Tsize_t ci = 0; ci < nprimitives; ci ++ )
	sp += recv( theClient, &c[ ci ], Tsizeof( Tchar ), 0 );
      s = c;
      data = &s;
      theDataSize += sp;
      break;
    case tTypeDouble:
      sp = recv( theClient, d, Tsizeof( Tdouble ), 0 );
      data = d;
      theDataSize += sp;
      break;
    case tTypeInt:
      sp = recv( theClient, i, Tsizeof( Tint ), 0 );
      data = i;
      theDataSize += sp;
      break;
    case tTypeUnknown:
    case tTypeObject:
    case tTypeFloat:
    default:
      break;
  }

  TDataElement* e = new TDataElement( data, eltype, id );

  delete [] c;
  delete [] i;
  delete [] d;

  return( e );
}
