// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TINPUTOBJECTSOCKET_HH
#define __TINPUTOBJECTSOCKET_HH

#include "TGlobals.hh"
#include "TObjectSocket.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TDataFilter;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;

class TInputObjectSocket
  : public TObjectSocket, public TInputObjectStream
{

  private:
    enum { tDefaultBackLog = 5 };

  private:
    Tint theClient;

  public:
    TInputObjectSocket( Tint port = tDefaultPortNumber );
    TInputObjectSocket( TDataFilter* filter, Tint port = tDefaultPortNumber );

    ~TInputObjectSocket();

  public:
    TStreamableObject* ReadData();

  private:
    Tvoid initialize();
    TDataRecord* getDataRecord();
    TDataSection* getDataSection();
    TDataSegment* getDataSegment();
    TDataElement* getDataElement();

  public:
    inline Tint GetClient() const;

};

inline Tint TInputObjectSocket::GetClient() const
{
  return( theClient );
}

#endif
