// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TOBJECTFILE_HH
#define __TOBJECTFILE_HH

#include "TGlobals.hh"

// ơθͤФʤʤ
// 㳰θͤФʤʤ

class TObjectFile
{

  public:
    enum { 
      tSeekBegin = SEEK_SET, 
      tSeekCurrent = SEEK_CUR, 
      tSeekEnd = SEEK_END
    };

  protected:
    Tstring theFileName;
    Tstring theMode;
    TFileStream* theFileStream;

  public:
    TObjectFile( const Tstring& filename, const Tstring& mode );

  protected:
    virtual ~TObjectFile();

  public:
    inline const Tstring& GetFileName() const;
    inline const Tstring& GetMode() const;
    inline TFileStream* GetFileStream() const;

    inline Tvoid SetFileName( const Tstring& filename );
    inline Tvoid SetMode( const Tstring& mode );

  public:
    //inline const Tvoid* SetFileStream() const;
    inline Tvoid SetOffset( Tint offset, Tint whence = tSeekCurrent );
    inline Tint GetOffset();

};

inline const Tstring& TObjectFile::GetFileName() const
{ 
  return( theFileName );
}

inline const Tstring& TObjectFile::GetMode() const
{ 
  return( theMode );
}

inline TFileStream* TObjectFile::GetFileStream() const
{
  return( theFileStream );
}

inline Tvoid TObjectFile::SetFileName( const Tstring& filename )
{
  theFileName = filename;
  return;
}

inline Tvoid TObjectFile::SetMode( const Tstring& mode )
{
  // reopenʤƤ
  theMode = mode;
  return;
}

inline Tvoid TObjectFile::SetOffset( Tint offset, Tint whence )
{
  fseek( theFileStream, (Tlong)offset, whence );
  return;
}


inline Tint TObjectFile::GetOffset()
{
  return( (Tint)( ftell( theFileStream ) ) );
}

#endif
