// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TOBJECTSOCKET_HH
#define __TOBJECTSOCKET_HH

#include "TGlobals.hh"

class TObjectSocket
{

  protected:
    enum { tDefaultPortNumber = 18150 };

  protected:
    Tint theFileDescriptor;
    Tint thePortNumber;
    struct sockaddr_in theAddress;

  public:
    TObjectSocket( Tint portnumber );

  protected:
    virtual ~TObjectSocket();

  public:
    inline Tint GetFileDescriptor() const;
    inline Tint GetPortNumber() const;
    inline const struct sockaddr_in& GetAddress() const;

};

inline Tint TObjectSocket::GetFileDescriptor() const
{
  return( theFileDescriptor );
}

inline Tint TObjectSocket::GetPortNumber() const
{
  return( thePortNumber );
}

inline const struct sockaddr_in& TObjectSocket::GetAddress() const
{
  return( theAddress );
}

#endif
