// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TOUTPUTOBJECTFILE_HH
#define __TOUTPUTOBJECTFILE_HH

#include "TGlobals.hh"
#include "TObjectFile.hh"
#include "TStreamableObject.hh"
#include "TOutputObjectStream.hh"
#include "TDataFilter.hh"

class TStreamableObject;
class TDataFilter;

class TOutputObjectFile
  : public TObjectFile, public TOutputObjectStream
{

  public:
    TOutputObjectFile( const Tstring& filename, const Tstring& mode = "w" );
    TOutputObjectFile( TDataFilter* filter, const Tstring& filename, const Tstring& mode = "w" );
    ~TOutputObjectFile();

  public:
    inline Tint WriteData( TStreamableObject* object );

};

inline Tint TOutputObjectFile::WriteData( TStreamableObject* object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;
  if ( HasFilter() )
    theDataSize = theDataFilter -> Filter( object, this );
  else
    theDataSize = object -> WriteData( this );
  return( theDataSize );
}

#endif
