// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TOutputObjectSocket.hh"

TOutputObjectSocket::TOutputObjectSocket( const Tstring& hostname, Tint port )
  : TObjectSocket( port ), TOutputObjectStream( tSocketStream ), 
    theServerName( hostname ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::TOutputObjectSocket( Tint port )
  : TObjectSocket( port ), TOutputObjectStream( tSocketStream ), 
    theServerName( "localhost" ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::TOutputObjectSocket( TDataFilter* filter, const Tstring& hostname, Tint port )
  : TObjectSocket( port ), TOutputObjectStream( filter, tSocketStream ), 
    theServerName( hostname ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::TOutputObjectSocket( TDataFilter* filter, Tint port )
  : TObjectSocket( port ), TOutputObjectStream( filter, tSocketStream ), 
    theServerName( "localhost" ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::~TOutputObjectSocket()
{;}

Tvoid TOutputObjectSocket::initialize()
{
  theHostInformation = gethostbyname( theServerName.data() );
  if ( !theHostInformation ) {
    perror( __FILE__ );
    exit( -errno );
  }
  theAddress.sin_family = PF_INET;
  theAddress.sin_port = htons( thePortNumber );
  theAddress.sin_addr.s_addr =
    *( (unsigned long *)( *( theHostInformation -> h_addr_list ) ) );

  if ( connect( theFileDescriptor, (struct sockaddr *)&theAddress, (socklen_t)Tsizeof( theAddress ) ) == -1 ) {
    perror( __FILE__ );
    exit( -errno );
  }

  return;
}
