// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TOUTPUTOBJECTSOCKET_HH
#define __TOUTPUTOBJECTSOCKET_HH

#include "TGlobals.hh"
#include "TObjectSocket.hh"
#include "TOutputObjectStream.hh"
#include "TDataFilter.hh"
#include "TStreamableObject.hh"

class TStreamableObject;
class TDataFilter;

class TOutputObjectSocket
  : public TObjectSocket, public TOutputObjectStream
{

  private:
    Tstring theServerName;
    struct hostent* theHostInformation;

  public:
    TOutputObjectSocket( const Tstring& hostname = "localhost", Tint port = tDefaultPortNumber );
    TOutputObjectSocket( Tint port );
    TOutputObjectSocket( TDataFilter* filter, const Tstring& hostname = "localhost", Tint port = tDefaultPortNumber );
    TOutputObjectSocket( TDataFilter* filter, Tint port );

    ~TOutputObjectSocket();

  public:
    inline Tint WriteData( TStreamableObject* object );

  public:
    inline struct hostent* GetHostInformation() const;
    inline const Tstring& GetServerName() const;


  private:
    Tvoid initialize();

};

inline struct hostent* TOutputObjectSocket::GetHostInformation() const
{
  return( theHostInformation );
}

inline const Tstring& TOutputObjectSocket::GetServerName() const
{
  return( theServerName );
}

inline Tint TOutputObjectSocket::WriteData( TStreamableObject* object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;

  if ( HasFilter() )
    theDataSize = theDataFilter -> Filter( object, this );
  else
    theDataSize = object -> WriteData( this );

  return( theDataSize );
}

#endif
