// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TReadoutList.hh"
#include "TOutputObjectFile.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"

TReadoutList::TReadoutList( Tint id, Tint capacity )
  : TReadoutSectionList( capacity, tDefaultReallocationParameter ), theID( id )
{;}

TReadoutList::~TReadoutList()
{;}

Tvoid TReadoutList::Print( Tostream& tos )
{
  Tstring head = "* Readout List, ";
  tos << head << "ID: " << theID;
  tos << Twspace << "Capacity: " << theCapacity;
  tos << Twspace << "Entry: " << theNumberOfEntries << Tendl;
  
  for ( Tint i = 0; i < theNumberOfEntries; i ++ )
    theObjects[ i ] -> Print( tos );

  return;
}

TDataRecord* TReadoutList::ReadData()
{
  TDataRecord* d = new TDataRecord( theID, theNumberOfEntries );
  TReadoutSection* sec = 0;

  SetPosition( 0 );
  while ( ( sec = Next() ) )
    d -> Add( sec -> ReadData() );

  return( d );
}
