// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TSoftwareTimerModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareTimerModule::TSoftwareTimerModule( const Tstring& unit, Tint nchannel, Tint id )
  : TSoftwareModule( nchannel, tStatusSuccess, id ), 
    theIntervalTime( 0.0 ), theCurrentTime( 0.0 ),thePreviousTime( 0.0 )
{
  if ( unit == Tsec || unit == Tmsec || unit == Tusec )
    theUnit = unit;
  else
    theUnit = Tmsec;
  setCurrentTime();
}

TSoftwareTimerModule::~TSoftwareTimerModule()
{;}

Tvoid TSoftwareTimerModule::FillData( TDataSegment* segment )
{
  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    if ( i == tIntervalTime )
      segment -> Add( new TDataElement( &theIntervalTime, tTypeDouble, tIntervalTime ) );
    else if ( i == tCurrentTime )
      segment -> Add( new TDataElement( &theCurrentTime, tTypeDouble, tCurrentTime ) );
    else if ( i == tPreviousTime )
      segment -> Add( new TDataElement( &thePreviousTime, tTypeDouble, tPreviousTime ) );
    else if ( i == tUnit )
      segment -> Add( new TDataElement( &theUnit, tTypeString, tUnit ) );
  }
  return;
}

Tvoid TSoftwareTimerModule::FillData( TDataElement* element )
{
  Tint ch = element -> GetID();
  Tint tmp = -EFAULT;
  if ( ch < 0 || ( ch >= theNumberOfChannels ) )
    element -> FillData( &tmp, tTypeInt );
  else if ( ch == tIntervalTime )
    element -> FillData( &theIntervalTime, tTypeDouble );
  else if ( ch == tCurrentTime )
    element -> FillData( &theCurrentTime, tTypeDouble );
  else if ( ch == tPreviousTime )
    element -> FillData( &thePreviousTime, tTypeDouble );
  else if ( ch == tUnit )
    element -> FillData( &theUnit, tTypeString );
  return;
}

Tvoid TSoftwareTimerModule::Print( Tostream& tos ) const
{
  Tstring head = Twspace + Twspace + Twspace + "* Software Timer, ";
  tos << head << "Status: " << theStatus << Twspace;
  tos << "ID: " << theID << Tendl;

  for ( Tint i = 0; i < theNumberOfChannels; i ++ ) {
    tos << Twspace << head << "Channel: " << i;
    if ( i == tIntervalTime )
      tos << Twspace << "Intr: " << theIntervalTime << Tspace << "[" << theUnit << "]" << Tendl;
    else if ( i == tCurrentTime )
      tos << Twspace << "Curr: " << theCurrentTime << Tspace << "[" << theUnit << "]" << Tendl;
    else if ( i == tPreviousTime )
      tos << Twspace << "Prev: " << thePreviousTime << Tspace << "[" << theUnit << "]" << Tendl;
    else if ( i == tUnit )
      tos << Twspace << "Unit: " << "[" << theUnit << "]" << Tendl;
  }

  return;
}

Tvoid TSoftwareTimerModule::setCurrentTime()
{
  thePreviousTime = theCurrentTime;

  struct timeval now;
  gettimeofday( &now, 0 );

  Tdouble tv_sec = (Tdouble)( now.tv_sec );
  Tdouble tv_usec = (Tdouble)( now.tv_usec );

  Tdouble usec = ( tv_sec * 1.0e+6 ) + tv_usec;

  if ( theUnit == Tsec ) {
    theCurrentTime = usec * 1.0e-6;
  } else if ( theUnit == Tmsec ) {
    theCurrentTime = usec * 1.0e-3;
  } else if ( theUnit == Tusec ) {
    theCurrentTime = usec;
  }

  theIntervalTime = theCurrentTime - thePreviousTime;
  if ( theIntervalTime < 0 )
    theIntervalTime = (Tdouble)( -EFAULT );

  return;
}
