// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TSTREAMABLEOBJECT_HH
#define __TSTREAMABLEOBJECT_HH

#include "TGlobals.hh"

class TOutputObjectStream;

class TStreamableObject
{

  protected:
    Tobject_t theObjectType;
    Tint theID;

  public:
    TStreamableObject( Tobject_t objecttype, Tint id );

  public:
    inline Tobject_t GetObjectType() const;
    inline Tint GetID() const;
    inline Tvoid SetObjectType( Tobject_t objecttype );
    inline Tvoid SetID( Tint id );

  protected:
    virtual ~TStreamableObject();

  protected:
    virtual Tint GetDataSize() = 0;
    virtual Tvoid Print( Tostream& tos = Tstd::Tcout ) = 0;

  public:
    virtual Tint WriteData( TOutputObjectStream* output ) = 0;

};

inline Tobject_t TStreamableObject::GetObjectType() const
{
  return( theObjectType );
}

inline Tint TStreamableObject::GetID() const
{
  return( theID );
}

inline Tvoid TStreamableObject::SetObjectType( Tobject_t objecttype )
{ 
  theObjectType = objecttype;
}

inline Tvoid TStreamableObject::SetID( Tint id )
{
  theID = id;
}

#endif
