// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"

int main( int argc, char** argv )
{
  if ( argc != 2 ) {
    Tcerr << "Usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  const Tstring filename = argv[ 1 ];
  TInputObjectFile* ifile = new TInputObjectFile( filename );

  TDataRecord* rec = 0;
  TDataSection* sec = 0;
  TDataSegment* seg = 0;
  TDataElement* ele = 0;
  Tint data;

  while ( ( rec = (TDataRecord*)( ifile -> ReadData() ) ) ) {
    rec -> SetPosition( 0 );
    while ( ( sec = rec -> Next() ) ) {
      sec -> SetPosition( 0 );
      while ( ( seg = sec -> Next() ) ) {
	seg -> SetPosition( 0 );
	while ( ( ele = seg -> Next() ) ) {
	  switch ( ele -> GetElementType() ) {
	    case tTypeInt:
	      data = *( (Tint*)( ele -> GetData() ) );
	      Tcout << data << Tspace;
	      break;
	    case tTypeString:
	      Tcout << *( (Tstring*)( ele -> GetData() ) ) << Tspace;
	      break;
	    case tTypeDouble:
	      Tcout << *( (Tdouble*)( ele -> GetData() ) ) << Tspace;
	      break;
	    default:
	      Tcerr << "WARNNING: NOT SUPPORTED DATA !!!" << Tspace;
	      break;
	  }
	}
      }
    }
    Tcout << Tendl;
    delete rec;
  }

  delete ifile;
  return( 0 );
}
