// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TOutputObjectSocket.hh"

TDataRecord* create( Tint val );

int main( int argc, char** argv )
{
  enum { exCommand, exHost, exPort, exNumberOfEvents, exNumberOfArguments };
  if ( argc != exNumberOfArguments ) {
    Tcerr << "Usage: " << argv[ exCommand ];
    Tcerr << Tspace << "<host>";
    Tcerr << Tspace << "<port>";
    Tcerr << Tspace << "<nevent>";
    Tcerr << Tendl;
    return( -1 );
  }

  const Tstring host = argv[ exHost ];
  const Tint port = atoi( argv[ exPort ] );
  const Tint nev = atoi( argv[ exNumberOfEvents ] );

  TOutputObjectSocket* osocket = new TOutputObjectSocket( host, port );

  Tint datasize = 0;

  for ( Tint i = 0; i < nev; i ++ ) {

    TDataRecord* record = create( i );
    osocket -> WriteData( record );
    //record -> Print();
    datasize += record -> GetDataSize();

    delete record;
  }

  Tcout << Tendl;
  Tcout << Ttab << datasize << " byte data ---> ";
  Tcout << osocket -> GetServerName() << Tendl;
  Tcout << Tendl;

  delete osocket;
  return( 0 );

}

// dummy data create
TDataRecord* create( Tint val )
{
  static const Tint recid = 0x1000;
  static const Tint secid = 0x1100;
  static const Tint seg1id = 0x1110;
  static const Tint seg2id = 0x1120;
  static const Tint seg3id = 0x1130;

  TDataRecord* rec = new TDataRecord( recid );
  TDataSection* sec = new TDataSection( secid );
  TDataSegment* seg1 = new TDataSegment( seg1id );
  TDataSegment* seg2 = new TDataSegment( seg2id );
  TDataSegment* seg3 = new TDataSegment( seg3id );


  for ( Tint i = 0; i < 8; i ++ ) {
    Tint data = i + i * i + 0x1234 * val;
    seg1 -> Add( new TDataElement( &data, tTypeInt, i ) );
  }


  Ttime_t time_now;
  Tint pasttime = (Tint)time( &time_now );
  struct tm* tm_now = localtime( &time_now );
  Tsize_t length = 64;
  Tchar* tmp = new Tchar[ length ];
  strftime( tmp, length,"%Y/%m/%d %H:%M:%S", tm_now );
  string tstr = tmp;
  delete [] tmp;
  seg2 -> Add( new TDataElement( &pasttime, tTypeInt, 0 ) );
  seg2 -> Add( new TDataElement( &tstr, tTypeString, 1 ) );


  for ( Tdouble i = 0.0; i < 16.0; i ++ ) {
    Tdouble data = sin( i * i * val + val );
    seg3 -> Add( new TDataElement( &data, tTypeDouble, (Tint)i ) );
  }

  sec -> Add( seg1 );
  sec -> Add( seg2 );
  sec -> Add( seg3 );
  rec -> Add( sec );

  return( rec );
}
