// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include <stdlib.h>
#include <unistd.h>
#include <sys/time.h>
#include "TGlobals.hh"
#include "Tvector.hh"             // with inline
//#include "trash/tvector.hh"     // without inline

typedef Tvector<Tdouble> dlist;
Tint getMicroTime( )
{
  struct timeval now;
  gettimeofday( &now, 0 );  
  return( now.tv_sec*1000000 + now.tv_usec );
}

int main( int argc, char** argv )
{
  static const Tint maxsize = 100;
  static const Tint times = 100000;

  Tint before = getMicroTime();
  for ( Tint i = 0; i < times; i ++ ) {
    dlist* l = new dlist();
    for ( Tdouble i = 0.0; i < maxsize; i ++ )
      l -> Add( new Tdouble( i ) );

    while ( ( l -> Next() ) ) {
      l -> GetCapacity();
      l -> GetNumberOfEntries();
      l -> GetPosition();
      l -> Begin();
      l -> End();
      l -> GetEndOfPosition();
    }

    delete l;
  }
  Tint after = getMicroTime();

  Tcout << after << Ttab << before << Ttab << after - before << Tendl;
  return( 0 );
}
