// ============================================================
//  ExInputObjectFile.hh
//  04-October-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#ifndef __EXINPUTOBJECTFILE_HH
#define __EXINPUTOBJECTFILE_HH

#include <stdio.h>
#include "ExObjectFile.hh"

class ExStreamableObject;
class ExVMEReadoutList;
class ExVMEReadoutModule;
class ExVMEReadoutChannel;

class ExInputObjectFile : public ExObjectFile {

private:
  int theObjectType;
  size_t theLastEventSize;
  size_t theEventSize;

public:
  enum { UNKNOWN, EXVMEREADOUTLIST, EXVMEREADOUTMODULE, EXVMEREADOUTCHANNEL };


public:
  ExInputObjectFile( char* path, int objecttype, char* mode = "r" );
  ExInputObjectFile( char* path, char* mode = "r" );
  ~ExInputObjectFile() {;}

public:
  ExStreamableObject* get();
  
  inline int getObjectType() const { return( theObjectType ); }
  inline void setObjectType( int objecttype ) { theObjectType = objecttype; }
  inline size_t getEventSize() const { return( theEventSize ); }
  inline size_t getLastEventSize() const { return( theLastEventSize ); }

private:
  ExVMEReadoutList* create( ExVMEReadoutList* l );
  ExVMEReadoutModule* create( ExVMEReadoutModule* m );
  ExVMEReadoutChannel* create( ExVMEReadoutChannel* c );

};

#endif
