// ============================================================
//  ExStreamableObject.hh
//  04-October-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#ifndef __EXSTREAMABLEOBJECT_HH
#define __EXSTREAMABLEOBJECT_HH

#include <iostream.h>
#include <stdio.h>

class ExObjectFile;
class ostream;

class ExStreamableObject {

public:
  enum { OBJECT_UNKNOWN = -1, OBJECT_DATA = 1, OBJECT_ARRAY = 2 };
  enum { ID_UNKNOWN = -1 };

protected:
  int theObjectType;
  int theID;

public:
  ExStreamableObject();
  ExStreamableObject( int objecttype, int id = ID_UNKNOWN );

public:
  inline int getObjectType() const { return( theObjectType ); }
  inline int getID() const { return( theID ); }
  inline void setObjectType( int type ) { theObjectType = type; }
  inline void setID( int id ) { theID = id; }

protected:
  virtual ~ExStreamableObject() {;}

protected:
  virtual size_t getDataSize() = 0;
  virtual void dump( ostream& os = cout ) = 0;

public:
  virtual size_t put( ExObjectFile* objectfile ) = 0;

};

#endif
