// ============================================================
//  ExVMERPV130Module.hh
//  09-December-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#ifndef __EXVMERPV130MODULE_HH
#define __EXVMERPV130MODULE_HH

#include "ExVMEModule.hh"

class ExVMEReadoutModule;
class ExVMEReadoutChannel;

class ExVMERPV130Module : public ExVMEModule {

private:
  enum {
    LATCH1 = 0x00, LATCH2 = 0x02, RSFF = 0x04, THROUGH = 0x06,
    PULSE = 0x08, LEVEL = 0x0a, CSR1 = 0x0c, CSR2 = 0x0e
  };

public:
  typedef enum read_t { 
    LATCH1_MODE, LATCH2_MODE, RSFF_MODE, THROUGH_MODE, N_MODES 
  };

public:
  ExVMERPV130Module( int offset, int mapsize = 0x1000, int mode = A16D16 );
  ~ExVMERPV130Module();

  // virtuals
  void clear();
  void update();
  void initialize();
  void fillData( ExVMEReadoutModule* module );
  void fillData( ExVMEReadoutChannel* channel );


  // local functions
  void pulse();
  void pulse( int channel );
  void level();
  void level( int channel );
  void enable();
  void disable();
  int read( read_t mode = THROUGH_MODE );
  int read( int channel, read_t mode = THROUGH_MODE );

};

#endif
