// ============================================================
//  ExVMEReadoutList.cc 
//  09-December-2001
//  Go Iwai [iwai@hep.sc.niigata-u.ac.jp]
// ============================================================
#include "ExVMEReadoutList.hh"
#include "ExObjectFile.hh"

ExVMEReadoutList::ExVMEReadoutList( int tablesize, int listid )
  : ExVMEReadoutModuleArray( tablesize ), 
    ExStreamableObject( OBJECT_ARRAY, listid )
{;}


void ExVMEReadoutList::dump( ostream& os )
{
  os << "$ Readout List from VME, ID: " << getID() << endl
     << "$ Maximum Entry for Module: " << getTableSize() << endl
     << "$ Current Counter: " << getCounter() << endl
     << "$ Inserted Module: " << getNumberOfEntries() << endl;

  for ( int i = 0; i < theNumberOfEntries; i ++ )
    theObjects[ i ] -> dump( os );

  return;
}

size_t ExVMEReadoutList::getDataSize()
{
  size_t total;
  total = sizeof(*this);
  for ( int i = 0; i < theNumberOfEntries; i ++ )
    total += theObjects[ i ] -> getDataSize();

  return( total );
}

size_t ExVMEReadoutList::put( ExObjectFile* objectfile )
{
  size_t size = fwrite( this, sizeof(*this), 1, objectfile -> getFILE() );
  for ( int i = 0; i < theNumberOfEntries; i ++ )
    size += theObjects[ i ] -> put( objectfile );
  return( size );
}

void ExVMEReadoutList::fillData()
{
  for ( int i = 0; i < theNumberOfEntries; i ++ )
    theObjects[ i ] -> fillData();
  return;
}

