// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TCOMMAND_HH
#define __TCOMMAND_HH

#include "TGlobals.hh"

class TCommand
{

  protected:
    Tstring theCommandName;
    Tstring theGuidance;

  public:
    TCommand( const Tstring& name, const Tstring& guidance = "" );
    virtual ~TCommand();

  public:
    const Tstring& GetCommandName() const;
    const Tstring& GetGuidance() const;
    Tvoid SetCommandName( const Tstring& name );
    Tvoid SetGuidance( const Tstring& guidance );
    Tvoid ShowCommandDescription() const;

  public:
    virtual Tvoid Execute() = 0;

};

inline const Tstring& TCommand::GetCommandName() const
{
  return( theCommandName );
}

inline const Tstring& TCommand::GetGuidance() const
{
  return( theGuidance );
}

inline Tvoid TCommand::SetCommandName( const Tstring& name )
{
  theCommandName = name;
  return;
}

inline Tvoid TCommand::SetGuidance( const Tstring& guidance )
{
  theGuidance = guidance;
  return;
}

#endif
