// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#ifndef __TOBJECTSHAREDMEMORY_HH
#define __TOBJECTSHAREDMEMORY_HH

#include "TGlobals.hh"

class TObjectSharedMemory
{

  public:
    enum { tWritable, tReadable, tNumberOfSemaphores };

  protected:
    Tstring theProjectName;
    Tint theSemaphoreID;
    Tint theSharedMemoryStorageID;
    Tint theSharedMemoryClientsID;
    Tint theNumberOfClients;

    Tvoid* theBeginOfMemoryAddress;
    Tvoid* theMemoryAddress;

  public:
    TObjectSharedMemory( const Tstring& projectName = Tproject + Thyphen + Tversion );

  protected:
    virtual ~TObjectSharedMemory();
    virtual Tvoid catchSignal( Tint signal ) = 0;

  public:
    //semaphore
    Tint GetLastAccessPID( Tint semnum );
    Tint GetSemaphoreValue( Tint semnum );
    Tint GetNumberOfWaitingProcesses( Tint semnum );
    Tvoid RemoveAllIPC();
    
    //shm
    Tvoid* Attach();
    Tint Detach();

  public:
    inline const Tstring& GetProjectName() const;
    inline Tint GetSemaphoreID() const;
    inline Tint GetSharedMemoryStorageID() const;
    inline Tint GetSharedMemoryClientsID() const;
    inline Tint GetNumberOfClients() const;
    inline Tvoid SetNumberOfClients( Tint nclients );
    Tvoid* GetBeginOfMemoryAddress() const;
    Tvoid* GetMemoryAddress() const;
    Tvoid SetMemoryAddress( Tvoid* address );



};

inline const Tstring& TObjectSharedMemory::GetProjectName() const
{
  return( theProjectName );
}

inline Tint TObjectSharedMemory::GetSemaphoreID() const
{
  return( theSemaphoreID );
}

inline Tint TObjectSharedMemory::GetSharedMemoryStorageID() const
{
  return( theSharedMemoryStorageID );
}

inline Tint TObjectSharedMemory::GetSharedMemoryClientsID() const
{
  return( theSharedMemoryClientsID );
}

inline Tint TObjectSharedMemory::GetNumberOfClients() const
{
  //åǤҤäƤ
  //attach
  return( theNumberOfClients );
}

inline Tvoid TObjectSharedMemory::SetNumberOfClients( Tint nclients )
{

  theNumberOfClients = nclients;
  return;
}

inline Tint TObjectSharedMemory::GetLastAccessPID( Tint semnum )
{
  Tint retval = semctl( theSemaphoreID, semnum, GETPID, 0 );
  if ( retval == -1 )
    perror( "TObjectSharedMemory::GetLastAccessPID" );
  return( retval );
}

inline Tint TObjectSharedMemory::GetSemaphoreValue( Tint semnum )
{
  Tint retval = semctl( theSemaphoreID, semnum, GETVAL, 0 );
  if ( retval == -1 )
    perror( "TObjectSharedMemory::GetSemaphoreValue" );
  return( retval );
}

inline Tint TObjectSharedMemory::GetNumberOfWaitingProcesses( Tint semnum )
{
  Tint retval = semctl( theSemaphoreID, semnum, GETNCNT, 0 );
  if ( retval == -1 )
    perror( "TObjectSharedMemory::GetNumberOfWaitingProcesses" );
  return( retval );
}

inline Tvoid TObjectSharedMemory::RemoveAllIPC()
{
  if ( semctl( theSemaphoreID, 0, IPC_RMID, 0 ) == -1 )
    perror( "TObjectSharedMemory::RemoveAllIPC" );
  if ( shmctl( theSharedMemoryStorageID, IPC_RMID, 0 ) == -1 )
    perror( "TObjectSharedMemory::RemoveAllIPC" );
  if ( shmctl( theSharedMemoryClientsID, IPC_RMID, 0 ) == -1 )
    perror( "TObjectSharedMemory::RemoveAllIPC" );
  return;
}

inline Tvoid* TObjectSharedMemory::GetBeginOfMemoryAddress() const
{
  return( theBeginOfMemoryAddress );
}

inline Tvoid* TObjectSharedMemory::GetMemoryAddress() const
{
  return( theMemoryAddress );
}

inline Tvoid TObjectSharedMemory::SetMemoryAddress( Tvoid* address )
{
  theMemoryAddress = address;
  return;
}

    Tvoid* Attach();
    Tint Detach();

inline Tvoid* TObjectSharedMemory::Attach(
inline Tvoid TObjectSharedMemory::
inline Tvoid TObjectSharedMemory::

#endif
