// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TShowRunManagerCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring name = "mshow";
static const Tstring desc = "print the status and information of run manager.";

TShowRunManagerCommand::TShowRunManagerCommand()
  : TCommand( name, desc )
{;}

TShowRunManagerCommand::~TShowRunManagerCommand()
{;}

Tvoid TShowRunManagerCommand::Execute()
{
  const TRunManager* manager = TRunManager::GetRunManager();
  manager -> ShowStatus();
  Tcout << "Waiting Command: " << ( manager -> GetWaitingCommands() ).size() << Tendl;
  if ( manager -> HasWaitingCommand() )
    manager -> ShowWaitingCommands();
  return;
}
