// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TSoftwareClockModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

Tstring TSoftwareClockModule::theCompleteTimeFormat = "%Y/%m/%d %a %H:%M:%S %z %Z";

TSoftwareClockModule::TSoftwareClockModule( Tint nchannel, Tint id )
  : TSoftwareModule( nchannel, id ), thePastTimeSice1970( 0 )
{
  setCurrentTime();
}

TSoftwareClockModule::TSoftwareClockModule( const TSoftwareClockModule& right )
  : TSoftwareModule( right ), 
    thePastTimeSice1970( right.thePastTimeSice1970 ),
    theCompleteTime( right.theCompleteTime ),
    theLocalYear( right.theLocalYear ),
    theLocalMonth( right.theLocalMonth ),
    theLocalDate( right.theLocalDate ),
    theLocalDay( right.theLocalDay ),
    theLocalHour( right.theLocalHour ),
    theLocalMinute( right.theLocalMinute ),
    theLocalSecond( right.theLocalSecond ),
    theLocalTimeZone( right.theLocalTimeZone )
{
  SetCompleteTimeFormat( right.GetCompleteTimeFormat() );
}

TSoftwareClockModule::~TSoftwareClockModule()
{;}

Tint TSoftwareClockModule::Clear()
{
  thePastTimeSice1970 = 0;
  theCompleteTime.erase();
  theLocalYear.erase();
  theLocalMonth.erase();
  theLocalDate.erase();
  theLocalDay.erase();
  theLocalHour.erase();
  theLocalMinute.erase();
  theLocalSecond.erase();
  theLocalTimeZone.erase();
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareClockModule::Update()
{
  setCurrentTime();
  return( theStatus = tStatusSuccess );
}

Tint TSoftwareClockModule::Initialize()
{
  Clear();
  SetCompleteTimeFormat( "%Y/%m/%d %a %H:%M:%S %z %Z" );
  return( theStatus = tStatusSuccess );
}

Tvoid TSoftwareClockModule::FillData( const TDataSegment& segment )
{
  TDataElement element( &thePastTimeSice1970, tTypeInt, tPastTimeSice1970 );
  ((TDataElementList*)(&segment)) -> push_back( element );

  for ( Tint i = tCompleteTime; i < theNumberOfChannels; i ++ ) {
    Tstring str = getStringData( i );
    TDataElement ele( &str, tTypeString, i );
    ((TDataElementList*)(&segment)) -> push_back( ele );
  }
  return;
}

Tvoid TSoftwareClockModule::FillData( const TDataElement& element )
{
  Tint ch = element.GetID();
  if ( ch < 0 || ch >= theNumberOfChannels ) {
    Tint err = -EFAULT;
    Tcerr << "TSoftwareClockModule::FillData: invalid ID" << Tendl;
    ((TDataElement*)(&element)) -> FillData( &err, tTypeInt );
  } else if ( ch == tPastTimeSice1970 ) {
    ((TDataElement*)(&element)) -> FillData( &thePastTimeSice1970, tTypeInt );
  } else {
    Tstring str = getStringData( ch );
    ((TDataElement*)(&element)) -> FillData( &str, tTypeString );
  }
  return;
}

const TSoftwareClockModule& TSoftwareClockModule::operator=( const TSoftwareClockModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  thePastTimeSice1970 = right.thePastTimeSice1970;
  theCompleteTime = right.theCompleteTime;
  SetCompleteTimeFormat( right.GetCompleteTimeFormat() );
  theLocalYear = right.theLocalYear;
  theLocalMonth = right.theLocalMonth;
  theLocalDate = right.theLocalDate;
  theLocalDay = right.theLocalDay;
  theLocalHour = right.theLocalHour;
  theLocalMinute = right.theLocalMinute;
  theLocalSecond = right.theLocalSecond;
  theLocalTimeZone = right.theLocalTimeZone;

  return( *this );
}

Tbool TSoftwareClockModule::operator==( const TSoftwareClockModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  ret &= ( thePastTimeSice1970 == right.thePastTimeSice1970 );
  ret &= ( theCompleteTime == right.theCompleteTime );
  ret &= ( GetCompleteTimeFormat() == right.GetCompleteTimeFormat() );
  ret &= ( theLocalYear == right.theLocalYear );
  ret &= ( theLocalMonth == right.theLocalMonth );
  ret &= ( theLocalDate == right.theLocalDate );
  ret &= ( theLocalDay == right.theLocalDay );
  ret &= ( theLocalHour == right.theLocalHour );
  ret &= ( theLocalMinute == right.theLocalMinute );
  ret &= ( theLocalSecond == right.theLocalSecond );
  ret &= ( theLocalTimeZone == right.theLocalTimeZone );

  return( ret );
}

Tbool TSoftwareClockModule::operator!=( const TSoftwareClockModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  ret &= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  ret &= ( thePastTimeSice1970 != right.thePastTimeSice1970 );
  ret &= ( theCompleteTime != right.theCompleteTime );
  ret &= ( GetCompleteTimeFormat() != right.GetCompleteTimeFormat() );
  ret &= ( theLocalYear != right.theLocalYear );
  ret &= ( theLocalMonth != right.theLocalMonth );
  ret &= ( theLocalDate != right.theLocalDate );
  ret &= ( theLocalDay != right.theLocalDay );
  ret &= ( theLocalHour != right.theLocalHour );
  ret &= ( theLocalMinute != right.theLocalMinute );
  ret &= ( theLocalSecond != right.theLocalSecond );
  ret &= ( theLocalTimeZone != right.theLocalTimeZone );

  return( ret );
}

Tvoid TSoftwareClockModule::setCurrentTime()
{
  static const Tsize_t max = 256;
  Ttime_t time_now = 0;
  thePastTimeSice1970 = (Tint)time( &time_now );
  struct tm* tm_now = localtime( &time_now );

  Tchar* s = new Tchar[ max ];

  strftime( s, max, theCompleteTimeFormat.c_str(), tm_now );
  theCompleteTime = s;

  strftime( s, max, "%Y", tm_now );
  theLocalYear = s;

  strftime( s, max, "%B", tm_now );
  theLocalMonth = s;

  strftime( s, max, "%d", tm_now );
  theLocalDate = s;

  strftime( s, max, "%A", tm_now );
  theLocalDay = s;

  strftime( s, max, "%H", tm_now );
  theLocalHour = s;

  strftime( s, max, "%M", tm_now );
  theLocalMinute = s;

  strftime( s, max, "%S", tm_now );
  theLocalSecond = s;

  strftime( s, max, "%Z", tm_now );
  theLocalTimeZone = s;
  
  delete [] s;
  return;
}

const Tstring& TSoftwareClockModule::getStringData( Tint channel ) const
{
  switch( channel ) {
    case tCompleteTime:
      return( theCompleteTime );
      break;
    case tCompleteTimeFormat:
      return( TSoftwareClockModule::theCompleteTimeFormat );
      break;
    case tLocalYear:
      return( theLocalYear );
      break;
    case tLocalMonth:
      return( theLocalMonth );
      break;
    case tLocalDate:
      return( theLocalDate );
      break;
    case tLocalDay:
      return( theLocalDay );
      break;
    case tLocalHour:
      return( theLocalHour );
      break;
    case tLocalMinute:
      return( theLocalMinute );
      break;
    case tLocalSecond:
      return( theLocalSecond );
      break;
    case tLocalTimeZone:
      return( theLocalTimeZone );
      break;
    default:
      return( theCompleteTime );
      break;
  }
}
