// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TGlobals.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TOutputObjectFile.hh"

TDataRecord create( Tint val );

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<nevent>" << Tendl;
    return( -1 );
  }
  const Tint nevent = atoi( argv[ 1 ] );
  const Tstring filename = "test.obj";
  TOutputObjectFile* ofile = new TOutputObjectFile( filename );
  Tint datasize1 = 0;
  Tint datasize2 = 0;

  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record = create( i );
    Tcout << record << Tendl;
    ofile -> WriteData( record );
    datasize1 += record.GetDataSize();
    datasize2 += ofile -> GetDataSize();
  }

  Tcout << Tendl;
  Tcout << Ttab << datasize1 << Tslash << datasize2;
  Tcout << Tspace << "byte data has been written down " << filename << Tendl;
  Tcout << Tendl;

  delete ofile;
  return( 0 );
}

TDataRecord create( Tint val )
{
  static const Tint recid = 0x1000;
  static const Tint secid = 0x1100;
  static const Tint seg1id = 0x1110;
  static const Tint seg2id = 0x1120;
  static const Tint seg3id = 0x1130;

  TDataRecord rec( recid );
  TDataSection sec( secid );
  TDataSegment seg1( seg1id );
  TDataSegment seg2( seg2id );
  TDataSegment seg3( seg3id );


  Ttime_t time_now;
  Tint pasttime = (Tint)time( &time_now );
  struct tm* tm_now = localtime( &time_now );
  Tsize_t length = 64;
  Tchar* tmp = new Tchar[ length ];
  strftime( tmp, length,"%Y/%m/%d %H:%M:%S", tm_now );
  string tstr = tmp;
  delete [] tmp;
  const Tint nstrdata = 2;
  string strdata[ nstrdata ] = { 
    "ABCDEF ABCDEF ABCDEF ABCDEF END", 
    "abcefghijklmnopqrstuvwxyz abcefghijklmnopqrstuvwxyz end"
  };
  const Tint ndata = 1000;
  TUshort array[ ndata ];
  for ( Tint i = 0; i < ndata; i ++ )
    array[ i ] = (TUshort)( i + i );
  
  seg1.push_back( TDataElement( &pasttime, tTypeInt, 0 ) );
  seg1.push_back( TDataElement( &tstr, tTypeString, 1 ) );
  seg1.push_back( TDataElement( strdata, tTypeString, 2, nstrdata ) );
  seg1.push_back( TDataElement( array, tTypeWord, 3, ndata ) );
   
  for ( Tint i = 0; i < 8; i ++ ) {
    Tint data = i + i * i + 0x1234 * val;
    seg2.push_back( TDataElement( &data, tTypeInt, i + 100 ) );
  }


  for ( Tdouble i = 0.0; i < 16.0; i ++ ) {
    Tdouble data = sin( i * i * val + val );
    seg3.push_back( TDataElement( &data, tTypeDouble, (Tint)i ) );
  }

  sec.push_back( seg1 );
  sec.push_back( seg2 );
  sec.push_back( seg3 );
  rec.push_back( sec );

  return( rec );
}
