// ============================================================================
//  $Id$
//  $Name$
// ============================================================================
#include "TEvent.hh"

TEvent::TEvent( Tint eventID, const TDataRecord& eventData )
  : theEventNumber( eventID ), theDataRecord( eventData )
{;}

TEvent::TEvent( const TEvent& right )
  : theEventNumber( right.theEventNumber ), 
    theDataRecord( right.theDataRecord )
{;}

TEvent::~TEvent()
{;}

const TEvent& TEvent::operator=( const TEvent& right )
{
  theEventNumber = right.theEventNumber;
  theDataRecord = right.theDataRecord;
  return( *this );
}

Tbool TEvent::operator==( const TEvent& right ) const
{
  if ( theEventNumber == right.theEventNumber && theDataRecord == right.theDataRecord )
    return( Ttrue );
  else
    return( Tfalse );
}

Tbool TEvent::operator!=( const TEvent& right ) const
{
  if ( theEventNumber != right.theEventNumber || theDataRecord != right.theDataRecord )
    return( Ttrue );
  else
    return( Tfalse );
}

